/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class DebeziumJsonSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "c";
    private static final String OP_DELETE = "d";
    public static final String FORMAT = "Debezium";
    private final JsonSerializationSchema jsonSerializer;
    private transient SeaTunnelRow genericRow;

    public DebeziumJsonSerializationSchema(SeaTunnelRowType rowType) {
        this.jsonSerializer = new JsonSerializationSchema(DebeziumJsonSerializationSchema.createJsonRowType(rowType));
        this.genericRow = new SeaTunnelRow(3);
    }

    public byte[] serialize(SeaTunnelRow row) {
        try {
            switch (row.getRowKind()) {
                case INSERT: 
                case UPDATE_AFTER: {
                    this.genericRow.setField(0, null);
                    this.genericRow.setField(1, (Object)row);
                    this.genericRow.setField(2, (Object)OP_INSERT);
                    return this.jsonSerializer.serialize(this.genericRow);
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    this.genericRow.setField(0, (Object)row);
                    this.genericRow.setField(1, null);
                    this.genericRow.setField(2, (Object)OP_DELETE);
                    return this.jsonSerializer.serialize(this.genericRow);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported operation '%s' for row kind.", row.getRowKind()));
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)row.toString(), (Throwable)t);
        }
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return new SeaTunnelRowType(new String[]{"before", "after", "op"}, new SeaTunnelDataType[]{databaseSchema, databaseSchema, BasicType.STRING_TYPE});
    }
}

