/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.multitablesink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.SinkIdentifier;

public class MultiTableSinkCommitter
implements SinkCommitter<MultiTableCommitInfo> {
    private final Map<String, SinkCommitter<?>> sinkCommitters;

    public MultiTableSinkCommitter(Map<String, SinkCommitter<?>> sinkCommitters) {
        this.sinkCommitters = sinkCommitters;
    }

    public List<MultiTableCommitInfo> commit(List<MultiTableCommitInfo> commitInfos) throws IOException {
        for (String sinkIdentifier : this.sinkCommitters.keySet()) {
            SinkCommitter<?> sinkCommitter = this.sinkCommitters.get(sinkIdentifier);
            if (sinkCommitter == null) continue;
            List commitInfo = commitInfos.stream().flatMap(multiTableCommitInfo -> multiTableCommitInfo.getCommitInfo().entrySet().stream().filter(entry -> ((SinkIdentifier)entry.getKey()).getTableIdentifier().equals(sinkIdentifier))).map(Map.Entry::getValue).collect(Collectors.toList());
            sinkCommitter.commit(commitInfo);
        }
        return new ArrayList<MultiTableCommitInfo>();
    }

    public void abort(List<MultiTableCommitInfo> commitInfos) throws IOException {
        for (String sinkIdentifier : this.sinkCommitters.keySet()) {
            SinkCommitter<?> sinkCommitter = this.sinkCommitters.get(sinkIdentifier);
            if (sinkCommitter == null) continue;
            List commitInfo = commitInfos.stream().map(multiTableCommitInfo -> multiTableCommitInfo.getCommitInfo().get(sinkIdentifier)).filter(Objects::nonNull).collect(Collectors.toList());
            sinkCommitter.abort(commitInfo);
        }
    }
}

