/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.split;

import com.google.auto.service.AutoService;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.transform.split.SplitTransform;
import org.apache.seatunnel.transform.split.SplitTransformConfig;

@AutoService(value={Factory.class})
public class SplitTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "Split";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{SplitTransformConfig.KEY_SEPARATOR, SplitTransformConfig.KEY_SPLIT_FIELD, SplitTransformConfig.KEY_OUTPUT_FIELDS}).build();
    }

    public TableTransform createTransform(@NonNull TableFactoryContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        SplitTransformConfig splitTransformConfig = SplitTransformConfig.of(context.getOptions());
        CatalogTable catalogTable = context.getCatalogTable();
        return () -> new SplitTransform(splitTransformConfig, catalogTable);
    }
}

