/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.copy;

import com.google.auto.service.AutoService;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.transform.copy.CopyFieldTransform;
import org.apache.seatunnel.transform.copy.CopyTransformConfig;

@AutoService(value={Factory.class})
public class CopyFieldTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "Copy";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().bundled(new Option[]{CopyTransformConfig.SRC_FIELD, CopyTransformConfig.DEST_FIELD}).bundled(new Option[]{CopyTransformConfig.FIELDS}).build();
    }

    public TableTransform createTransform(@NonNull TableFactoryContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        CopyTransformConfig copyTransformConfig = CopyTransformConfig.of(context.getOptions());
        CatalogTable catalogTable = context.getCatalogTable();
        return () -> new CopyFieldTransform(copyTransformConfig, catalogTable);
    }
}

