/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointErrorReportOperation;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class RestoredSplitOperation
extends TaskOperation {
    private List<byte[]> splits;
    private Integer subtaskIndex;

    public RestoredSplitOperation() {
    }

    public RestoredSplitOperation(TaskLocation enumeratorLocation, List<byte[]> splits, int subtaskIndex) {
        super(enumeratorLocation);
        this.splits = splits;
        this.subtaskIndex = subtaskIndex;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.splits.size());
        for (byte[] split2 : this.splits) {
            out.writeByteArray(split2);
        }
        out.writeInt(this.subtaskIndex);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int splitCount = in.readInt();
        this.splits = new ArrayList<byte[]>(splitCount);
        for (int i = 0; i < splitCount; ++i) {
            this.splits.add(in.readByteArray());
        }
        this.subtaskIndex = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        TaskExecutionService taskExecutionService = server.getTaskExecutionService();
        RetryUtils.retryWithException(() -> {
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)taskExecutionService.getTask(this.taskLocation);
            ClassLoader taskClassLoader = taskExecutionService.getExecutionContext(this.taskLocation.getTaskGroupLocation()).getClassLoader();
            ClassLoader mainClassLoader = Thread.currentThread().getContextClassLoader();
            ArrayList deserializeSplits = new ArrayList();
            try {
                Thread.currentThread().setContextClassLoader(taskClassLoader);
                for (byte[] split2 : this.splits) {
                    deserializeSplits.add(task.getSplitSerializer().deserialize(split2));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(mainClassLoader);
            }
            task.getExecutionContext().getTaskExecutionService().asyncExecuteFunction(this.taskLocation.getTaskGroupLocation(), () -> {
                try {
                    task.addSplitsBack(deserializeSplits, this.subtaskIndex);
                }
                catch (Exception e) {
                    task.getExecutionContext().sendToMaster(new CheckpointErrorReportOperation(this.taskLocation, e));
                }
            });
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }
}

