/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.cluster.Address;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.core.checkpoint.InternalCheckpointListener;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelSourceCollector;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.context.SourceReaderContext;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupAddressOperation;
import org.apache.seatunnel.engine.server.task.operation.source.RequestSplitOperation;
import org.apache.seatunnel.engine.server.task.operation.source.RestoredSplitOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceNoMoreElementOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceReaderEventOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceRegisterOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFlowLifeCycle<T, SplitT extends SourceSplit>
extends ActionFlowLifeCycle
implements InternalCheckpointListener {
    private static final Logger log = LoggerFactory.getLogger(SourceFlowLifeCycle.class);
    private final SourceAction<T, SplitT, ?> sourceAction;
    private final TaskLocation enumeratorTaskLocation;
    private Address enumeratorTaskAddress;
    private SourceReader<T, SplitT> reader;
    private transient Serializer<SplitT> splitSerializer;
    private final int indexID;
    private final TaskLocation currentTaskLocation;
    private SeaTunnelSourceCollector<T> collector;
    private final MetricsContext metricsContext;
    private final AtomicReference<SchemaChangePhase> schemaChangePhase = new AtomicReference();

    public SourceFlowLifeCycle(SourceAction<T, SplitT, ?> sourceAction, int indexID, TaskLocation enumeratorTaskLocation, SeaTunnelTask runningTask, TaskLocation currentTaskLocation, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        super(sourceAction, runningTask, completableFuture);
        this.sourceAction = sourceAction;
        this.indexID = indexID;
        this.enumeratorTaskLocation = enumeratorTaskLocation;
        this.currentTaskLocation = currentTaskLocation;
        this.metricsContext = metricsContext;
    }

    public void setCollector(SeaTunnelSourceCollector<T> collector) {
        this.collector = collector;
    }

    @Override
    public void init() throws Exception {
        this.splitSerializer = this.sourceAction.getSource().getSplitSerializer();
        this.reader = this.sourceAction.getSource().createReader(new SourceReaderContext(this.indexID, this.sourceAction.getSource().getBoundedness(), this, this.metricsContext));
        this.enumeratorTaskAddress = this.getEnumeratorTaskAddress();
    }

    @Override
    public void open() throws Exception {
        this.reader.open();
        this.register();
    }

    private Address getEnumeratorTaskAddress() throws ExecutionException, InterruptedException {
        return (Address)this.runningTask.getExecutionContext().sendToMaster(new GetTaskGroupAddressOperation(this.enumeratorTaskLocation)).get();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        super.close();
    }

    public void collect() throws Exception {
        if (!this.prepareClose.booleanValue()) {
            if (this.schemaChanging()) {
                log.debug("schema is changing, stop reader collect records");
                Thread.sleep(200L);
                return;
            }
            this.reader.pollNext(this.collector);
            if (this.collector.isEmptyThisPollNext()) {
                Thread.sleep(100L);
            } else {
                this.collector.resetEmptyThisPollNext();
            }
            if (this.collector.captureSchemaChangeBeforeCheckpointSignal()) {
                if (this.schemaChangePhase.get() != null) {
                    throw new IllegalStateException("previous schema changes in progress, schemaChangePhase: " + this.schemaChangePhase.get());
                }
                this.runningTask.triggerSchemaChangeBeforeCheckpoint().get();
                this.schemaChangePhase.set(SchemaChangePhase.createBeforePhase());
                log.info("triggered schema-change-before checkpoint, stopping collect data");
            } else if (this.collector.captureSchemaChangeAfterCheckpointSignal()) {
                if (this.schemaChangePhase.get() != null) {
                    throw new IllegalStateException("previous schema changes in progress, schemaChangePhase: " + this.schemaChangePhase.get());
                }
                this.runningTask.triggerSchemaChangeAfterCheckpoint().get();
                this.schemaChangePhase.set(SchemaChangePhase.createAfterPhase());
                log.info("triggered schema-change-after checkpoint, stopping collect data");
            }
        } else {
            Thread.sleep(100L);
        }
    }

    public void signalNoMoreElement() {
        try {
            this.prepareClose = true;
            this.runningTask.getExecutionContext().sendToMember(new SourceNoMoreElementOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (Exception e) {
            log.warn("source close failed {}", e);
            throw new RuntimeException(e);
        }
    }

    private void register() {
        try {
            this.runningTask.getExecutionContext().sendToMember(new SourceRegisterOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source register failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void requestSplit() {
        try {
            this.runningTask.getExecutionContext().sendToMember(new RequestSplitOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void sendSourceEventToEnumerator(SourceEvent sourceEvent) {
        try {
            this.runningTask.getExecutionContext().sendToMember(new SourceReaderEventOperation(this.enumeratorTaskLocation, this.currentTaskLocation, sourceEvent), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void receivedSplits(List<SplitT> splits) {
        if (splits.isEmpty()) {
            this.reader.handleNoMoreSplits();
        } else {
            this.reader.addSplits(splits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerBarrier(Barrier barrier) throws Exception {
        log.debug("source trigger barrier [{}]", (Object)barrier);
        long startTime = System.currentTimeMillis();
        Object object = this.collector.getCheckpointLock();
        synchronized (object) {
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            if (barrier.snapshot()) {
                List<byte[]> states = AbstractTask.serializeStates(this.splitSerializer, this.reader.snapshotState(barrier.getId()));
                this.runningTask.addState(barrier, ActionStateKey.of(this.sourceAction), states);
            }
            this.runningTask.ack(barrier);
            log.debug("source ack barrier finished, taskId: [{}]", (Object)this.runningTask.getTaskID());
            this.collector.sendRecordToNext(new Record<Barrier>(barrier));
            log.debug("send record to next finished, taskId: [{}]", (Object)this.runningTask.getTaskID());
        }
        log.debug("trigger barrier [{}] finished, cost: {}ms. taskLocation: [{}]", barrier.getId(), System.currentTimeMillis() - startTime, this.currentTaskLocation);
        CheckpointType checkpointType = ((CheckpointBarrier)barrier).getCheckpointType();
        if (this.schemaChanging() && checkpointType.isSchemaChangeCheckpoint()) {
            if (checkpointType.isSchemaChangeBeforeCheckpoint() && this.schemaChangePhase.get().isBeforePhase()) {
                this.schemaChangePhase.get().setCheckpointId(barrier.getId());
            } else if (checkpointType.isSchemaChangeAfterCheckpoint() && this.schemaChangePhase.get().isAfterPhase()) {
                this.schemaChangePhase.get().setCheckpointId(barrier.getId());
            } else {
                throw new IllegalStateException(String.format("schema-change checkpoint[%s,%s] and phase[%s] is not matched", new Object[]{barrier.getId(), checkpointType, this.schemaChangePhase.get().getPhase()}));
            }
            log.info("lock checkpoint[{}] waiting for complete..., phase: [{}]", (Object)barrier.getId(), (Object)this.schemaChangePhase.get().getPhase());
        }
    }

    private boolean schemaChanging() {
        return this.schemaChangePhase.get() != null;
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.reader.notifyCheckpointComplete(checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.reader.notifyCheckpointAborted(checkpointId);
        if (this.schemaChangePhase.get() != null && this.schemaChangePhase.get().getCheckpointId() == checkpointId) {
            throw new IllegalStateException(String.format("schema-change checkpoint[%s] is aborted, phase: [%s]", checkpointId, this.schemaChangePhase.get().getPhase()));
        }
    }

    @Override
    public void notifyCheckpointEnd(long checkpointId) throws Exception {
        if (this.schemaChangePhase.get() != null && this.schemaChangePhase.get().getCheckpointId() == checkpointId) {
            log.info("notify schema-change checkpoint[{}] end, phase: [{}]", (Object)checkpointId, (Object)this.schemaChangePhase.get().getPhase());
            this.schemaChangePhase.set(null);
        }
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        if (actionStateList.isEmpty()) {
            return;
        }
        List<byte[]> splits = actionStateList.stream().map(ActionSubtaskState::getState).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            this.runningTask.getExecutionContext().sendToMember(new RestoredSplitOperation(this.enumeratorTaskLocation, splits, this.indexID), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }

    private static class SchemaChangePhase
    implements Serializable {
        private static final String PHASE_CHANGE_BEFORE = "SCHEMA-CHANGE-BEFORE";
        private static final String PHASE_CHANGE_AFTER = "SCHEMA-CHANGE-AFTER";
        private final String phase;
        private volatile long checkpointId = -1L;

        public static SchemaChangePhase createBeforePhase() {
            return new SchemaChangePhase(PHASE_CHANGE_BEFORE);
        }

        public static SchemaChangePhase createAfterPhase() {
            return new SchemaChangePhase(PHASE_CHANGE_AFTER);
        }

        public boolean isBeforePhase() {
            return PHASE_CHANGE_BEFORE.equals(this.phase);
        }

        public boolean isAfterPhase() {
            return PHASE_CHANGE_AFTER.equals(this.phase);
        }

        public void setCheckpointId(long checkpointId) {
            if (this.checkpointId != -1L) {
                throw new IllegalStateException("checkpointId is already set");
            }
            this.checkpointId = checkpointId;
        }

        public String getPhase() {
            return this.phase;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }

        public String toString() {
            return "SourceFlowLifeCycle.SchemaChangePhase(phase=" + this.getPhase() + ", checkpointId=" + this.getCheckpointId() + ")";
        }

        private SchemaChangePhase(String phase) {
            this.phase = phase;
        }
    }
}

