/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointErrorReportOperation;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointBarrierTriggerOperation
extends TaskOperation {
    private static final Logger log = LoggerFactory.getLogger(CheckpointBarrierTriggerOperation.class);
    protected Barrier barrier;

    public CheckpointBarrierTriggerOperation(Barrier barrier, TaskLocation taskLocation) {
        super(taskLocation);
        this.barrier = barrier;
    }

    @Override
    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.barrier);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.barrier = (Barrier)in.readObject();
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            Object task = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation()).getTaskGroup().getTask(this.taskLocation.getTaskID());
            task.getExecutionContext().getTaskExecutionService().asyncExecuteFunction(this.taskLocation.getTaskGroupLocation(), () -> {
                try {
                    log.debug("CheckpointBarrierTriggerOperation [{}]", (Object)this.taskLocation);
                    task.triggerBarrier(this.barrier);
                }
                catch (Exception e) {
                    task.getExecutionContext().sendToMaster(new CheckpointErrorReportOperation(this.taskLocation, e));
                }
            });
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public CheckpointBarrierTriggerOperation() {
    }
}

