/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache.subscriber;

import com.hazelcast.client.map.impl.querycache.subscriber.ListenerInfo;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheToListenerMapper {
    private static final ConstructorFunction<String, Collection<ListenerInfo>> LISTENER_SET_CONSTRUCTOR = new ConstructorFunction<String, Collection<ListenerInfo>>(){

        @Override
        public Collection<ListenerInfo> createNew(String arg) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    };
    private final ConcurrentMap<String, Collection<ListenerInfo>> registrations = new ConcurrentHashMap<String, Collection<ListenerInfo>>();

    QueryCacheToListenerMapper() {
    }

    public UUID addListener(String cacheId, ListenerAdapter listenerAdapter, EventFilter filter2) {
        Collection<ListenerInfo> adapters = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, cacheId, LISTENER_SET_CONSTRUCTOR);
        UUID id = UuidUtil.newUnsecureUUID();
        ListenerInfo info = new ListenerInfo(filter2, listenerAdapter, id);
        adapters.add(info);
        return id;
    }

    public boolean removeListener(String cacheId, UUID listenerId) {
        Collection<ListenerInfo> adapters = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, cacheId, LISTENER_SET_CONSTRUCTOR);
        Iterator<ListenerInfo> iterator2 = adapters.iterator();
        while (iterator2.hasNext()) {
            ListenerInfo listenerInfo = iterator2.next();
            UUID listenerInfoId = listenerInfo.getId();
            if (!listenerInfoId.equals(listenerId)) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    public void removeAllListeners(String cacheId) {
        this.registrations.remove(cacheId);
    }

    public boolean hasListener(String cacheId) {
        Collection listenerInfos = (Collection)this.registrations.get(cacheId);
        return !CollectionUtil.isEmpty(listenerInfos);
    }

    public boolean hasAnyQueryCacheRegistered() {
        return !this.registrations.isEmpty();
    }

    Collection<ListenerInfo> getListenerInfos(String cacheId) {
        Collection infos = (Collection)this.registrations.get(cacheId);
        return CollectionUtil.isEmpty(infos) ? Collections.emptySet() : infos;
    }
}

