/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceIsShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceSubmitToMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceSubmitToPartitionCodec;
import com.hazelcast.client.impl.proxy.IExecutorDelegatingFuture;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.executor.LocalExecutorStats;
import com.hazelcast.executor.impl.ExecutionCallbackAdapter;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientExecutorServiceProxy
extends ClientProxy
implements IExecutorService {
    private final Random random = new Random(-System.currentTimeMillis());

    public ClientExecutorServiceProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.submit(command);
    }

    @Override
    public void executeOnKeyOwner(@Nonnull Runnable command, @Nonnull Object key) {
        this.submitToKeyOwnerInternal(this.toData(command), key, null);
    }

    @Override
    public void executeOnMember(@Nonnull Runnable command, @Nonnull Member member) {
        Preconditions.checkNotNull(member, "member must not be null");
        this.submitToTargetInternal(this.toData(command), member, null);
    }

    @Override
    public void executeOnMembers(@Nonnull Runnable command, @Nonnull Collection<Member> members) {
        Preconditions.checkNotNull(members, "members must not be null");
        for (Member member : members) {
            this.executeOnMember(command, member);
        }
    }

    @Override
    public void execute(@Nonnull Runnable command, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    @Override
    public void executeOnMembers(@Nonnull Runnable command, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    @Override
    public void executeOnAllMembers(@Nonnull Runnable command) {
        Collection<Member> memberList = this.getContext().getClusterService().getMemberList();
        for (Member member : memberList) {
            this.executeOnMember(command, member);
        }
    }

    @Override
    public <T> Future<T> submitToMember(@Nonnull Callable<T> task, @Nonnull Member member) {
        Preconditions.checkNotNull(member, "member must not be null");
        return this.submitToTargetInternal(this.toData(task), member, (T)null);
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(@Nonnull Callable<T> task, @Nonnull Collection<Member> members) {
        Preconditions.checkNotNull(members, "members must not be null");
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(members.size());
        Data taskData = this.toData(task);
        for (Member member : members) {
            Future<Object> f = this.submitToTargetInternal(taskData, member, (T)null);
            futureMap.put(member, f);
        }
        return futureMap;
    }

    @Override
    public <T> Future<T> submit(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(@Nonnull Callable<T> task) {
        Collection<Member> memberList = this.getContext().getClusterService().getMemberList();
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(memberList.size());
        Data taskData = this.toData(task);
        for (Member m3 : memberList) {
            Future<Object> f = this.submitToTargetInternal(taskData, m3, (T)null);
            futureMap.put(m3, f);
        }
        return futureMap;
    }

    public void submitToMember(@Nonnull Runnable command, @Nonnull Member member, @Nullable ExecutionCallback callback) {
        Preconditions.checkNotNull(member, "member must not be null");
        this.submitToTargetInternal(this.toData(command), member, callback);
    }

    @Override
    public void submitToMembers(@Nonnull Runnable command, @Nonnull Collection<Member> members, @Nonnull MultiExecutionCallback callback) {
        Preconditions.checkNotNull(members, "members must not be null");
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(command, member, (ExecutionCallback)executionCallback);
        }
    }

    @Override
    public <T> void submitToMember(@Nonnull Callable<T> task, @Nonnull Member member, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(member, "member must not be null");
        this.submitToTargetInternal(this.toData(task), member, callback);
    }

    @Override
    public <T> void submitToMembers(@Nonnull Callable<T> task, @Nonnull Collection<Member> members, @Nonnull MultiExecutionCallback callback) {
        Preconditions.checkNotNull(members, "members must not be null");
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        Data taskData = this.toData(task);
        members.forEach(member -> {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, (Member)member);
            this.submitToTargetInternal(taskData, (Member)member, executionCallback);
        });
    }

    public void submit(@Nonnull Runnable task, @Nonnull MemberSelector memberSelector, @Nullable ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public void submitToMembers(@Nonnull Runnable task, @Nonnull MemberSelector memberSelector, @Nonnull MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public <T> void submit(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector, @Nullable ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public <T> void submitToMembers(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector, @Nonnull MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public void submitToAllMembers(@Nonnull Runnable command, @Nonnull MultiExecutionCallback callback) {
        Collection<Member> memberList = this.getContext().getClusterService().getMemberList();
        this.submitToMembers(command, memberList, callback);
    }

    @Override
    public <T> void submitToAllMembers(@Nonnull Callable<T> task, @Nonnull MultiExecutionCallback callback) {
        Collection<Member> memberList = this.getContext().getClusterService().getMemberList();
        this.submitToMembers(task, memberList, callback);
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable command) {
        Object partitionKey = this.getTaskPartitionKey(command);
        Data taskData = this.toData(command);
        if (partitionKey != null) {
            return this.submitToKeyOwnerInternal(taskData, partitionKey, null);
        }
        return this.submitToRandomInternal(taskData, null);
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable command, T result2) {
        Object partitionKey = this.getTaskPartitionKey(command);
        Data taskData = this.toData(command);
        if (partitionKey != null) {
            return this.submitToKeyOwnerInternal(taskData, partitionKey, result2);
        }
        return this.submitToRandomInternal(taskData, result2);
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        Object partitionKey = this.getTaskPartitionKey(task);
        if (partitionKey != null) {
            return this.submitToKeyOwner(task, partitionKey);
        }
        return this.submitToRandomInternal(this.toData(task), null);
    }

    @Override
    public <T> void submit(@Nonnull Runnable command, @Nullable ExecutionCallback<T> callback) {
        Object partitionKey = this.getTaskPartitionKey(command);
        Data task = this.toData(command);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal(task, partitionKey, callback);
        } else {
            this.submitToRandomWithCallbackInternal(task, callback);
        }
    }

    @Override
    public <T> void submit(@Nonnull Callable<T> task, @Nullable ExecutionCallback<T> callback) {
        Object partitionKey = this.getTaskPartitionKey(task);
        Data taskData = this.toData(task);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal(taskData, partitionKey, callback);
        } else {
            this.submitToRandomWithCallbackInternal(taskData, callback);
        }
    }

    @Override
    public <T> Future<T> submitToKeyOwner(@Nonnull Callable<T> task, @Nonnull Object key) {
        return this.submitToKeyOwnerInternal(this.toData(task), key, null);
    }

    public void submitToKeyOwner(@Nonnull Runnable command, @Nonnull Object key, @Nonnull ExecutionCallback callback) {
        this.submitToKeyOwnerInternal(this.toData(command), key, callback);
    }

    @Override
    public <T> void submitToKeyOwner(@Nonnull Callable<T> task, @Nonnull Object key, @Nullable ExecutionCallback<T> callback) {
        this.submitToKeyOwnerInternal(this.toData(task), key, callback);
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public void shutdown() {
        ClientMessage request = ExecutorServiceShutdownCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        ClientMessage request = ExecutorServiceIsShutdownCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return ExecutorServiceIsShutdownCodec.decodeResponse(response);
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit, "unit must not be null");
        return false;
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) {
        Preconditions.checkNotNull(tasks, "tasks must not be null");
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        ArrayList<Future<T>> result2 = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            futures.add(this.submitToRandomInternal(this.toData(callable), null));
        }
        for (Future future : futures) {
            Object value = this.retrieveResult(future);
            result2.add(InternalCompletableFuture.newCompletedFuture(value, this.getSerializationService()));
        }
        return result2;
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    private Object getTaskPartitionKey(Object task) {
        if (task instanceof PartitionAware) {
            return ((PartitionAware)task).getPartitionKey();
        }
        return null;
    }

    @Nonnull
    private <T> Future<T> submitToKeyOwnerInternal(@Nonnull Data task, @Nonnull Object key, T defaultValue) {
        Preconditions.checkNotNull(task, "task should not be null");
        Preconditions.checkNotNull(key, "key should not be null");
        UUID uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        ClientMessage request = ExecutorServiceSubmitToPartitionCodec.encodeRequest(this.name, uuid, task);
        ClientInvocationFuture f = this.invokeOnPartitionOwner(request, partitionId);
        return this.delegatingFuture(f, uuid, partitionId, defaultValue);
    }

    private <T> Future<T> submitToKeyOwnerInternal(@Nonnull Data task, @Nonnull Object key, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, "task should not be null");
        Preconditions.checkNotNull(key, "key should not be null");
        UUID uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        ClientMessage request = ExecutorServiceSubmitToPartitionCodec.encodeRequest(this.name, uuid, task);
        ClientInvocationFuture f = this.invokeOnPartitionOwner(request, partitionId);
        InternalCompletableFuture delegatingFuture = (InternalCompletableFuture)this.delegatingFuture(f, uuid, partitionId, null);
        if (callback != null) {
            ((CompletableFuture)delegatingFuture.whenCompleteAsync(new ExecutionCallbackAdapter<T>(callback))).whenCompleteAsync((v, t) -> {
                if (t instanceof RejectedExecutionException) {
                    callback.onFailure((Throwable)t);
                }
            }, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
        return delegatingFuture;
    }

    @Nonnull
    private <T> Future<T> submitToRandomInternal(Data task, T defaultValue) {
        Preconditions.checkNotNull(task, "task should not be null");
        UUID uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        ClientMessage request = ExecutorServiceSubmitToPartitionCodec.encodeRequest(this.name, uuid, task);
        ClientInvocationFuture f = this.invokeOnPartitionOwner(request, partitionId);
        return this.delegatingFuture(f, uuid, partitionId, defaultValue);
    }

    private <T> void submitToRandomWithCallbackInternal(Data task, ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, "task should not be null");
        UUID uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        ClientMessage request = ExecutorServiceSubmitToPartitionCodec.encodeRequest(this.name, uuid, task);
        ClientInvocationFuture f = this.invokeOnPartitionOwner(request, partitionId);
        InternalCompletableFuture delegatingFuture = (InternalCompletableFuture)this.delegatingFuture(f, uuid, partitionId, null);
        if (callback != null) {
            ((CompletableFuture)delegatingFuture.whenCompleteAsync(new ExecutionCallbackAdapter<T>(callback))).whenCompleteAsync((v, t) -> {
                if (t instanceof RejectedExecutionException) {
                    callback.onFailure((Throwable)t);
                }
            }, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
    }

    private <T> Future<T> submitToTargetInternal(@Nonnull Data task, Member member, T defaultValue) {
        Preconditions.checkNotNull(task, "task should not be null");
        UUID uuid = this.getUUID();
        ClientMessage request = ExecutorServiceSubmitToMemberCodec.encodeRequest(this.name, uuid, task, member.getUuid());
        ClientInvocationFuture f = this.invokeOnTarget(request, member);
        return this.delegatingFuture(f, uuid, member, defaultValue);
    }

    private <T> void submitToTargetInternal(@Nonnull Data task, Member member, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, "task should not be null");
        UUID uuid = this.getUUID();
        ClientMessage request = ExecutorServiceSubmitToMemberCodec.encodeRequest(this.name, uuid, task, member.getUuid());
        ClientInvocationFuture f = this.invokeOnTarget(request, member);
        InternalCompletableFuture delegatingFuture = (InternalCompletableFuture)this.delegatingFuture(f, uuid, member, null);
        if (callback != null) {
            ((CompletableFuture)delegatingFuture.whenCompleteAsync(new ExecutionCallbackAdapter<T>(callback))).whenCompleteAsync((v, t) -> {
                if (t instanceof RejectedExecutionException) {
                    callback.onFailure((Throwable)t);
                }
            }, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
    }

    public String toString() {
        return "IExecutorService{name='" + this.name + '\'' + '}';
    }

    private <T> Future<T> delegatingFuture(ClientInvocationFuture f, UUID uuid, Member member, T defaultValue) {
        return new IExecutorDelegatingFuture<T>(f, this.getContext(), uuid, defaultValue, ExecutorServiceSubmitToMemberCodec::decodeResponse, this.name, member);
    }

    @Nonnull
    private <T> Future<T> delegatingFuture(ClientInvocationFuture f, UUID uuid, int partitionId, T defaultValue) {
        return new IExecutorDelegatingFuture<T>(f, this.getContext(), uuid, defaultValue, ExecutorServiceSubmitToPartitionCodec::decodeResponse, this.name, partitionId);
    }

    private <T> Object retrieveResult(Future<T> f) {
        Object response;
        try {
            response = f.get();
        }
        catch (Exception e) {
            response = e;
        }
        return response;
    }

    private List<Member> selectMembers(MemberSelector memberSelector) {
        Preconditions.checkNotNull(memberSelector, "memberSelector must not be null");
        ArrayList<Member> selected = new ArrayList<Member>();
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        for (Member member : members) {
            if (!memberSelector.select(member)) continue;
            selected.add(member);
        }
        if (selected.isEmpty()) {
            throw new RejectedExecutionException("No member selected with memberSelector[" + memberSelector + "]");
        }
        return selected;
    }

    private ClientInvocationFuture invokeOnPartitionOwner(ClientMessage request, int partitionId) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId);
            return clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ClientInvocationFuture invokeOnTarget(ClientMessage request, Member target) {
        try {
            ClientInvocation invocation = new ClientInvocation(this.getClient(), request, (Object)this.getName(), target.getUuid());
            return invocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private UUID getUUID() {
        return UuidUtil.newUnsecureUUID();
    }

    private int getPartitionId(@Nonnull Object key) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return partitionService.getPartitionId(key);
    }

    private int randomPartitionId() {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return this.random.nextInt(partitionService.getPartitionCount());
    }

    private static final class MultiExecutionCallbackWrapper
    implements MultiExecutionCallback {
        private final MultiExecutionCallback multiExecutionCallback;
        private final Map<Member, Object> values;
        private final AtomicInteger members;

        private MultiExecutionCallbackWrapper(int memberSize, @Nonnull MultiExecutionCallback multiExecutionCallback) {
            Preconditions.checkNotNull(multiExecutionCallback, "multiExecutionCallback must not be null");
            this.multiExecutionCallback = multiExecutionCallback;
            this.values = Collections.synchronizedMap(new HashMap(memberSize));
            this.members = new AtomicInteger(memberSize);
        }

        @Override
        public void onResponse(Member member, Object value) {
            this.multiExecutionCallback.onResponse(member, value);
            this.values.put(member, value);
            int waitingResponse = this.members.decrementAndGet();
            if (waitingResponse == 0) {
                this.onComplete(this.values);
            }
        }

        @Override
        public void onComplete(Map<Member, Object> values) {
            this.multiExecutionCallback.onComplete(values);
        }
    }

    private static final class ExecutionCallbackWrapper<T>
    implements ExecutionCallback<T> {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper;
        Member member;

        private ExecutionCallbackWrapper(MultiExecutionCallbackWrapper multiExecutionCallback, Member member) {
            this.multiExecutionCallbackWrapper = multiExecutionCallback;
            this.member = member;
        }

        @Override
        public void onResponse(T response) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, response);
        }

        @Override
        public void onFailure(Throwable t) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, t);
        }
    }
}

