/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ListIntegerCodec {
    private ListIntegerCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Integer> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 4]);
        Iterator<Integer> iterator2 = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeInt(frame.content, i * 4, iterator2.next());
        }
        clientMessage.add(frame);
    }

    public static List<Integer> decode(ClientMessage.ForwardFrameIterator iterator2) {
        return ListIntegerCodec.decode(iterator2.next());
    }

    public static List<Integer> decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 4;
        ArrayList<Integer> result2 = new ArrayList<Integer>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            result2.add(FixedSizeTypesCodec.decodeInt(frame.content, i * 4));
        }
        return result2;
    }
}

