/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntryListUUIDUUIDCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 34;

    private EntryListUUIDUUIDCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<UUID, UUID>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 34]);
        Iterator<Map.Entry<UUID, UUID>> iterator2 = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            Map.Entry<UUID, UUID> entry = iterator2.next();
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 34, entry.getKey());
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 34 + 17, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<UUID, UUID>> decode(ClientMessage.ForwardFrameIterator iterator2) {
        ClientMessage.Frame frame = iterator2.next();
        int itemCount = frame.content.length / 34;
        ArrayList<Map.Entry<UUID, UUID>> result2 = new ArrayList<Map.Entry<UUID, UUID>>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            UUID key = FixedSizeTypesCodec.decodeUUID(frame.content, i * 34);
            UUID value = FixedSizeTypesCodec.decodeUUID(frame.content, i * 34 + 17);
            result2.add(new AbstractMap.SimpleEntry<UUID, UUID>(key, value));
        }
        return result2;
    }
}

