/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import java.util.concurrent.RejectedExecutionException;

public class PartitionCapacityPermit
implements CapacityPermit {
    private final String name;
    private final int partition;
    private final int capacity;
    private int permits;

    PartitionCapacityPermit(String name, int permits, int partition2) {
        this.name = name;
        this.capacity = permits;
        this.permits = permits;
        this.partition = partition2;
    }

    @Override
    public void acquire() throws RejectedExecutionException {
        if (this.permits <= 0) {
            throw new RejectedExecutionException("Maximum capacity (" + this.capacity + ") of tasks reached for partition (" + this.partition + ") and scheduled executor (" + this.name + "). Reminder, that tasks must be disposed if not needed.");
        }
        --this.permits;
    }

    @Override
    public void acquireQuietly() {
        --this.permits;
    }

    @Override
    public void release() {
        ++this.permits;
    }

    @Override
    public int totalAcquired() {
        return this.capacity - this.permits;
    }
}

