/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config.server;

import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;

public class SlotServiceConfig
implements Serializable {
    private boolean dynamicSlot = ServerConfigOptions.DYNAMIC_SLOT.defaultValue();
    private int slotNum = ServerConfigOptions.SLOT_NUM.defaultValue();

    public void setSlotNum(int slotNum) {
        Preconditions.checkPositive(slotNum, ServerConfigOptions.SLOT_NUM + " must be > 0");
        this.slotNum = slotNum;
    }

    public boolean isDynamicSlot() {
        return this.dynamicSlot;
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public void setDynamicSlot(boolean dynamicSlot) {
        this.dynamicSlot = dynamicSlot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotServiceConfig)) {
            return false;
        }
        SlotServiceConfig other = (SlotServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDynamicSlot() != other.isDynamicSlot()) {
            return false;
        }
        return this.getSlotNum() == other.getSlotNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlotServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isDynamicSlot() ? 79 : 97);
        result2 = result2 * 59 + this.getSlotNum();
        return result2;
    }

    public String toString() {
        return "SlotServiceConfig(dynamicSlot=" + this.isDynamicSlot() + ", slotNum=" + this.getSlotNum() + ")";
    }
}

