/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionUtil;

public interface RequiredOption {
    public List<Option<?>> getOptions();

    public static class BundledRequiredOptions
    implements RequiredOption {
        private final List<Option<?>> requiredOption;

        BundledRequiredOptions(List<Option<?>> requiredOption) {
            this.requiredOption = requiredOption;
        }

        public static BundledRequiredOptions of(Option<?> ... requiredOption) {
            return new BundledRequiredOptions(new ArrayList(Arrays.asList(requiredOption)));
        }

        public static BundledRequiredOptions of(List<Option<?>> requiredOption) {
            return new BundledRequiredOptions(requiredOption);
        }

        public List<Option<?>> getRequiredOption() {
            return this.requiredOption;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BundledRequiredOptions)) {
                return false;
            }
            BundledRequiredOptions that = (BundledRequiredOptions)obj;
            return Objects.equals(this.requiredOption, that.requiredOption);
        }

        public int hashCode() {
            return this.requiredOption.hashCode();
        }

        public String toString() {
            return String.format("Bundled Required options: %s", OptionUtil.getOptionKeys(this.requiredOption));
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.requiredOption;
        }
    }

    public static class ConditionalRequiredOptions
    implements RequiredOption {
        private final Expression expression;
        private final List<Option<?>> requiredOption;

        ConditionalRequiredOptions(Expression expression, List<Option<?>> requiredOption) {
            this.expression = expression;
            this.requiredOption = requiredOption;
        }

        public static ConditionalRequiredOptions of(Expression expression, List<Option<?>> requiredOption) {
            return new ConditionalRequiredOptions(expression, requiredOption);
        }

        public static ConditionalRequiredOptions of(Condition<?> condition, List<Option<?>> requiredOption) {
            return new ConditionalRequiredOptions(Expression.of(condition), requiredOption);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public List<Option<?>> getRequiredOption() {
            return this.requiredOption;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConditionalRequiredOptions)) {
                return false;
            }
            ConditionalRequiredOptions that = (ConditionalRequiredOptions)obj;
            return Objects.equals(this.expression, that.expression) && Objects.equals(this.requiredOption, that.requiredOption);
        }

        public int hashCode() {
            return this.requiredOption.hashCode();
        }

        public String toString() {
            return String.format("Condition expression: %s, Required options: %s", this.expression, OptionUtil.getOptionKeys(this.requiredOption));
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.requiredOption;
        }
    }

    public static class AbsolutelyRequiredOptions
    implements RequiredOption {
        private final List<Option<?>> requiredOption;

        AbsolutelyRequiredOptions(List<Option<?>> requiredOption) {
            this.requiredOption = requiredOption;
        }

        public static AbsolutelyRequiredOptions of(Option<?> ... requiredOption) {
            return new AbsolutelyRequiredOptions(new ArrayList(Arrays.asList(requiredOption)));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbsolutelyRequiredOptions)) {
                return false;
            }
            AbsolutelyRequiredOptions that = (AbsolutelyRequiredOptions)obj;
            return Objects.equals(this.requiredOption, that.requiredOption);
        }

        public int hashCode() {
            return this.requiredOption.hashCode();
        }

        public String toString() {
            return String.format("Absolutely required options: '%s'", OptionUtil.getOptionKeys(this.requiredOption));
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.requiredOption;
        }

        public List<Option<?>> getRequiredOption() {
            return this.requiredOption;
        }
    }

    public static class ExclusiveRequiredOptions
    implements RequiredOption {
        private final List<Option<?>> exclusiveOptions;

        public ExclusiveRequiredOptions(@NonNull List<Option<?>> exclusiveOptions) {
            if (exclusiveOptions == null) {
                throw new NullPointerException("exclusiveOptions is marked @NonNull but is null");
            }
            this.exclusiveOptions = exclusiveOptions;
        }

        public static ExclusiveRequiredOptions of(Option<?> ... options) {
            return new ExclusiveRequiredOptions(new ArrayList(Arrays.asList(options)));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExclusiveRequiredOptions)) {
                return false;
            }
            ExclusiveRequiredOptions that = (ExclusiveRequiredOptions)obj;
            return Objects.equals(this.exclusiveOptions, that.exclusiveOptions);
        }

        public int hashCode() {
            return Objects.hash(this.exclusiveOptions);
        }

        public String toString() {
            return String.format("Exclusive required set options: %s", OptionUtil.getOptionKeys(this.exclusiveOptions));
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.exclusiveOptions;
        }

        public List<Option<?>> getExclusiveOptions() {
            return this.exclusiveOptions;
        }
    }
}

