/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.IPredicate;
import com.hazelcast.map.impl.mapstore.writebehind.NodeWideUsedCapacityCounter;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounter;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounterImpl;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import java.util.Collection;
import java.util.List;

class BoundedWriteBehindQueue<E extends DelayedEntry>
implements WriteBehindQueue<E> {
    final NodeWideUsedCapacityCounter nodeWideUsedCapacityCounter;
    private final WriteBehindQueue<E> queue;
    private final TxnReservedCapacityCounter txnReservedCapacityCounter;

    BoundedWriteBehindQueue(WriteBehindQueue<E> queue, NodeWideUsedCapacityCounter nodeWideUsedCapacityCounter) {
        this.queue = queue;
        this.nodeWideUsedCapacityCounter = nodeWideUsedCapacityCounter;
        this.txnReservedCapacityCounter = new TxnReservedCapacityCounterImpl(nodeWideUsedCapacityCounter);
    }

    @Override
    public void addFirst(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.addCapacity(collection.size());
        this.queue.addFirst(collection);
    }

    @Override
    public void addLast(E e, boolean addWithoutCapacityCheck) {
        if (e.getTxnId() != null && this.txnReservedCapacityCounter.hasReservedCapacity(e.getTxnId())) {
            this.txnReservedCapacityCounter.decrementOnlyReserved(e.getTxnId());
        } else if (addWithoutCapacityCheck) {
            this.nodeWideUsedCapacityCounter.add(1L);
        } else {
            this.nodeWideUsedCapacityCounter.checkAndAddCapacityOrThrowException(1);
        }
        this.queue.addLast(e, addWithoutCapacityCheck);
    }

    @Override
    public E peek() {
        return (E)((DelayedEntry)this.queue.peek());
    }

    @Override
    public boolean removeFirstOccurrence(E e) {
        boolean result2 = this.queue.removeFirstOccurrence(e);
        if (result2) {
            this.addCapacity(-1);
        }
        return result2;
    }

    @Override
    public int drainTo(Collection<E> collection) {
        int size2 = this.queue.drainTo(collection);
        this.addCapacity(-size2);
        return size2;
    }

    @Override
    public boolean contains(E e) {
        return this.queue.contains(e);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        int size2 = this.size();
        this.queue.clear();
        this.addCapacity(-size2);
        this.txnReservedCapacityCounter.releaseAllReservations();
    }

    @Override
    public List<E> asList() {
        return this.queue.asList();
    }

    @Override
    public void filter(IPredicate<E> predicate, Collection<E> collection) {
        this.queue.filter(predicate, collection);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.getClass().isAssignableFrom(clazz)) {
            return (T)this;
        }
        return this.queue.unwrap(clazz);
    }

    public TxnReservedCapacityCounter getTxnReservedCapacityCounter() {
        return this.txnReservedCapacityCounter;
    }

    private void addCapacity(int capacity) {
        this.nodeWideUsedCapacityCounter.checkAndAddCapacityOrThrowException(capacity);
    }
}

