/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.defaultserializers;

import com.hazelcast.internal.serialization.impl.defaultserializers.AbstractCollectionStreamSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class CopyOnWriteArrayListStreamSerializer<E>
extends AbstractCollectionStreamSerializer<CopyOnWriteArrayList<E>> {
    @Override
    public int getTypeId() {
        return -31;
    }

    @Override
    public CopyOnWriteArrayList<E> read(ObjectDataInput in) throws IOException {
        int size2 = in.readInt();
        ArrayList collection = new ArrayList(size2);
        this.deserializeEntriesInto(in, size2, collection);
        return new CopyOnWriteArrayList(collection);
    }

    @Override
    public void write(ObjectDataOutput out, CopyOnWriteArrayList<E> collection) throws IOException {
        Spliterator<E> cowSplitIterator = collection.spliterator();
        int size2 = (int)cowSplitIterator.getExactSizeIfKnown();
        assert (size2 != -1);
        out.writeInt(size2);
        cowSplitIterator.forEachRemaining(object -> {
            try {
                out.writeObject(object);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

