/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractFactoryWithPropertiesConfig;
import com.hazelcast.config.AbstractSymmetricEncryptionConfig;
import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.DynamicConfigurationConfig;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MemcacheProtocolConfig;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SqlConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.KerberosAuthenticationConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.SimpleAuthenticationConfig;
import com.hazelcast.config.security.TlsAuthenticationConfig;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.PersistenceAndHotRestartPersistenceMerger;
import com.hazelcast.internal.dynamicconfig.DynamicConfigXmlGenerator;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.Capacity;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.splitbrainprotection.impl.ProbabilisticSplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.RecentlyActiveSplitBrainProtectionFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigXmlGenerator {
    public static final String MASK_FOR_SENSITIVE_DATA = "****";
    private static final int INDENT = 5;
    private static final ILogger LOGGER = Logger.getLogger(ConfigXmlGenerator.class);
    private final boolean formatted;
    private final boolean maskSensitiveFields;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this(formatted, true);
    }

    public ConfigXmlGenerator(boolean formatted, boolean maskSensitiveFields) {
        this.formatted = formatted;
        this.maskSensitiveFields = maskSensitiveFields;
    }

    public String generate(Config config) {
        Preconditions.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        XmlGenerator gen = new XmlGenerator(xml);
        PersistenceAndHotRestartPersistenceMerger.merge(config.getHotRestartPersistenceConfig(), config.getPersistenceConfig());
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-").append(Versions.CURRENT_CLUSTER_VERSION.toString()).append(".xsd\">");
        gen.node("license-key", this.getOrMaskValue(config.getLicenseKey()), new Object[0]).node("instance-name", config.getInstanceName(), new Object[0]).node("cluster-name", config.getClusterName(), new Object[0]);
        this.managementCenterXmlGenerator(gen, config);
        gen.appendProperties(config.getProperties());
        this.securityXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.wanReplicationXmlGenerator(gen, config);
        this.networkConfigXmlGenerator(gen, config);
        this.advancedNetworkConfigXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.replicatedMapXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.mapXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.cacheXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.queueXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.multiMapXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.listXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.setXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.topicXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.ringbufferXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.executorXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.durableExecutorXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.scheduledExecutorXmlGenerator(gen, config);
        ConfigXmlGenerator.partitionGroupXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.cardinalityEstimatorXmlGenerator(gen, config);
        ConfigXmlGenerator.listenerXmlGenerator(gen, config);
        ConfigXmlGenerator.serializationXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.reliableTopicXmlGenerator(gen, config);
        ConfigXmlGenerator.liteMemberXmlGenerator(gen, config);
        ConfigXmlGenerator.nativeMemoryXmlGenerator(gen, config);
        this.persistenceXmlGenerator(gen, config);
        this.dynamicConfigurationXmlGenerator(gen, config);
        ConfigXmlGenerator.localDeviceConfigXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.flakeIdGeneratorXmlGenerator(gen, config);
        ConfigXmlGenerator.crdtReplicationXmlGenerator(gen, config);
        DynamicConfigXmlGenerator.pnCounterXmlGenerator(gen, config);
        ConfigXmlGenerator.splitBrainProtectionXmlGenerator(gen, config);
        ConfigXmlGenerator.cpSubsystemConfig(gen, config);
        ConfigXmlGenerator.metricsConfig(gen, config);
        ConfigXmlGenerator.instanceTrackingConfig(gen, config);
        ConfigXmlGenerator.sqlConfig(gen, config);
        ConfigXmlGenerator.jetConfig(gen, config);
        this.factoryWithPropertiesXmlGenerator(gen, "auditlog", config.getAuditlogConfig());
        ConfigXmlGenerator.userCodeDeploymentConfig(gen, config);
        ConfigXmlGenerator.integrityCheckerXmlGenerator(gen, config);
        xml.append("</hazelcast>");
        String xmlString = xml.toString();
        return this.formatted ? StringUtil.formatXml(xmlString, 5) : xmlString;
    }

    private String getOrMaskValue(String value) {
        return this.maskSensitiveFields ? MASK_FOR_SENSITIVE_DATA : value;
    }

    private void managementCenterXmlGenerator(XmlGenerator gen, Config config) {
        ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
        if (mcConfig != null) {
            gen.open("management-center", "scripting-enabled", mcConfig.isScriptingEnabled(), "console-enabled", mcConfig.isConsoleEnabled(), "data-access-enabled", mcConfig.isDataAccessEnabled());
            ConfigXmlGenerator.trustedInterfacesXmlGenerator(gen, mcConfig.getTrustedInterfaces());
            gen.close();
        }
    }

    private static void listenerXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getListenerConfigs().isEmpty()) {
            return;
        }
        gen.open("listeners", new Object[0]);
        for (ListenerConfig lc : config.getListenerConfigs()) {
            gen.node("listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private void securityXmlGenerator(XmlGenerator gen, Config config) {
        Map<String, RealmConfig> realms;
        SecurityConfig c = config.getSecurityConfig();
        if (c == null) {
            return;
        }
        gen.open("security", "enabled", c.isEnabled()).node("client-block-unmapped-actions", c.getClientBlockUnmappedActions(), new Object[0]);
        PermissionPolicyConfig ppc = c.getClientPolicyConfig();
        if (ppc.getClassName() != null) {
            gen.open("client-permission-policy", "class-name", ppc.getClassName()).appendProperties(ppc.getProperties()).close();
        }
        if ((realms = c.getRealmConfigs()) != null && !realms.isEmpty()) {
            gen.open("realms", new Object[0]);
            for (Map.Entry<String, RealmConfig> realmEntry : realms.entrySet()) {
                this.securityRealmGenerator(gen, realmEntry.getKey(), realmEntry.getValue());
            }
            gen.close();
        }
        ConfigXmlGenerator.addRealmReference(gen, "member-authentication", c.getMemberRealm());
        ConfigXmlGenerator.addRealmReference(gen, "client-authentication", c.getClientRealm());
        List<SecurityInterceptorConfig> sic = c.getSecurityInterceptorConfigs();
        if (!sic.isEmpty()) {
            gen.open("security-interceptors", new Object[0]);
            for (SecurityInterceptorConfig s2 : sic) {
                gen.open("interceptor", "class-name", s2.getClassName()).close();
            }
            gen.close();
        }
        ConfigXmlGenerator.appendSecurityPermissions(gen, "client-permissions", c.getClientPermissionConfigs(), new Object[]{"on-join-operation", c.getOnJoinPermissionOperation()});
        gen.close();
    }

    private static void addRealmReference(XmlGenerator gen, String refName, String realmName) {
        if (realmName != null) {
            gen.node(refName, null, "realm", realmName);
        }
    }

    protected void securityRealmGenerator(XmlGenerator gen, String name, RealmConfig c) {
        gen.open("realm", "name", name);
        if (c.isAuthenticationConfigured()) {
            gen.open("authentication", new Object[0]);
            ConfigXmlGenerator.jaasAuthenticationGenerator(gen, c.getJaasAuthenticationConfig());
            ConfigXmlGenerator.tlsAuthenticationGenerator(gen, c.getTlsAuthenticationConfig());
            ConfigXmlGenerator.ldapAuthenticationGenerator(gen, c.getLdapAuthenticationConfig());
            ConfigXmlGenerator.kerberosAuthenticationGenerator(gen, c.getKerberosAuthenticationConfig());
            ConfigXmlGenerator.simpleAuthenticationGenerator(gen, c.getSimpleAuthenticationConfig());
            gen.close();
        }
        if (c.isIdentityConfigured()) {
            TokenIdentityConfig ti;
            UsernamePasswordIdentityConfig upi;
            gen.open("identity", new Object[0]);
            CredentialsFactoryConfig cf = c.getCredentialsFactoryConfig();
            if (cf != null) {
                gen.open("credentials-factory", "class-name", cf.getClassName()).appendProperties(cf.getProperties()).close();
            }
            if ((upi = c.getUsernamePasswordIdentityConfig()) != null) {
                gen.node("username-password", null, "username", upi.getUsername(), "password", this.getOrMaskValue(upi.getPassword()));
            }
            if ((ti = c.getTokenIdentityConfig()) != null) {
                gen.node("token", this.getOrMaskValue(ti.getTokenEncoded()), "encoding", ti.getEncoding().toString());
            }
            ConfigXmlGenerator.kerberosIdentityGenerator(gen, c.getKerberosIdentityConfig());
            gen.close();
        }
        gen.close();
    }

    private static void tlsAuthenticationGenerator(XmlGenerator gen, TlsAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        XmlGenerator tlsGen = gen.open("tls", "roleAttribute", c.getRoleAttribute());
        ConfigXmlGenerator.addClusterLoginElements(tlsGen, c).close();
    }

    private static void ldapAuthenticationGenerator(XmlGenerator gen, LdapAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        ConfigXmlGenerator.addClusterLoginElements(gen.open("ldap", new Object[0]), c).node("url", c.getUrl(), new Object[0]).nodeIfContents("socket-factory-class-name", c.getSocketFactoryClassName(), new Object[0]).nodeIfContents("parse-dn", c.getParseDn(), new Object[0]).nodeIfContents("role-context", c.getRoleContext(), new Object[0]).nodeIfContents("role-filter", c.getRoleFilter(), new Object[0]).nodeIfContents("role-mapping-attribute", c.getRoleMappingAttribute(), new Object[0]).nodeIfContents("role-mapping-mode", (Object)c.getRoleMappingMode(), new Object[0]).nodeIfContents("role-name-attribute", c.getRoleNameAttribute(), new Object[0]).nodeIfContents("role-recursion-max-depth", c.getRoleRecursionMaxDepth(), new Object[0]).nodeIfContents("role-search-scope", (Object)c.getRoleSearchScope(), new Object[0]).nodeIfContents("user-name-attribute", c.getUserNameAttribute(), new Object[0]).nodeIfContents("system-user-dn", c.getSystemUserDn(), new Object[0]).nodeIfContents("system-user-password", c.getSystemUserPassword(), new Object[0]).nodeIfContents("system-authentication", c.getSystemAuthentication(), new Object[0]).nodeIfContents("security-realm", c.getSecurityRealm(), new Object[0]).nodeIfContents("password-attribute", c.getPasswordAttribute(), new Object[0]).nodeIfContents("user-context", c.getUserContext(), new Object[0]).nodeIfContents("user-filter", c.getUserFilter(), new Object[0]).nodeIfContents("user-search-scope", (Object)c.getUserSearchScope(), new Object[0]).nodeIfContents("skip-authentication", c.getSkipAuthentication(), new Object[0]).close();
    }

    private static void kerberosAuthenticationGenerator(XmlGenerator gen, KerberosAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        XmlGenerator kerberosGen = gen.open("kerberos", new Object[0]);
        ConfigXmlGenerator.addClusterLoginElements(kerberosGen, c).nodeIfContents("relax-flags-check", c.getRelaxFlagsCheck(), new Object[0]).nodeIfContents("use-name-without-realm", c.getUseNameWithoutRealm(), new Object[0]).nodeIfContents("security-realm", c.getSecurityRealm(), new Object[0]).nodeIfContents("keytab-file", c.getKeytabFile(), new Object[0]).nodeIfContents("principal", c.getPrincipal(), new Object[0]);
        ConfigXmlGenerator.ldapAuthenticationGenerator(kerberosGen, c.getLdapAuthenticationConfig());
        kerberosGen.close();
    }

    private static void simpleAuthenticationGenerator(XmlGenerator gen, SimpleAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        XmlGenerator simpleGen = gen.open("simple", new Object[0]);
        ConfigXmlGenerator.addClusterLoginElements(simpleGen, c).nodeIfContents("role-separator", c.getRoleSeparator(), new Object[0]);
        for (String username : c.getUsernames()) {
            simpleGen.open("user", "username", username, "password", c.getPassword(username));
            for (String role : c.getRoles(username)) {
                simpleGen.node("role", role, new Object[0]);
            }
            simpleGen.close();
        }
        simpleGen.close();
    }

    private static void kerberosIdentityGenerator(XmlGenerator gen, KerberosIdentityConfig c) {
        if (c == null) {
            return;
        }
        gen.open("kerberos", new Object[0]).nodeIfContents("realm", c.getRealm(), new Object[0]).nodeIfContents("security-realm", c.getSecurityRealm(), new Object[0]).nodeIfContents("keytab-file", c.getKeytabFile(), new Object[0]).nodeIfContents("principal", c.getPrincipal(), new Object[0]).nodeIfContents("service-name-prefix", c.getServiceNamePrefix(), new Object[0]).nodeIfContents("spn", c.getSpn(), new Object[0]).nodeIfContents("use-canonical-hostname", c.getUseCanonicalHostname(), new Object[0]).close();
    }

    private static XmlGenerator addClusterLoginElements(XmlGenerator gen, AbstractClusterLoginConfig<?> c) {
        gen.nodeIfContents("skip-identity", c.getSkipIdentity(), new Object[0]);
        gen.nodeIfContents("skip-endpoint", c.getSkipEndpoint(), new Object[0]);
        gen.nodeIfContents("skip-role", c.getSkipRole(), new Object[0]);
        return gen;
    }

    private static void jaasAuthenticationGenerator(XmlGenerator gen, JaasAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        ConfigXmlGenerator.appendLoginModules(gen, "jaas", c.getLoginModuleConfigs());
    }

    private static void appendSecurityPermissions(XmlGenerator gen, String tag, Set<PermissionConfig> cpc, Object ... attributes) {
        List<PermissionConfig.PermissionType> clusterPermTypes = Arrays.asList(PermissionConfig.PermissionType.ALL, PermissionConfig.PermissionType.CONFIG, PermissionConfig.PermissionType.TRANSACTION);
        if (!cpc.isEmpty()) {
            gen.open(tag, attributes);
            for (PermissionConfig p : cpc) {
                if (clusterPermTypes.contains((Object)p.getType())) {
                    gen.open(p.getType().getNodeName(), "principal", p.getPrincipal());
                } else {
                    gen.open(p.getType().getNodeName(), "principal", p.getPrincipal(), "name", p.getName());
                }
                if (!p.getEndpoints().isEmpty()) {
                    gen.open("endpoints", new Object[0]);
                    for (String endpoint : p.getEndpoints()) {
                        gen.node("endpoint", endpoint, new Object[0]);
                    }
                    gen.close();
                }
                if (!p.getActions().isEmpty()) {
                    gen.open("actions", new Object[0]);
                    for (String action : p.getActions()) {
                        gen.node("action", action, new Object[0]);
                    }
                    gen.close();
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void appendLoginModules(XmlGenerator gen, String tag, List<LoginModuleConfig> loginModuleConfigs) {
        gen.open(tag, new Object[0]);
        for (LoginModuleConfig lm : loginModuleConfigs) {
            ArrayList<String> attrs = new ArrayList<String>();
            attrs.add("class-name");
            attrs.add(lm.getClassName());
            if (lm.getUsage() != null) {
                attrs.add("usage");
                attrs.add(lm.getUsage().name());
            }
            gen.open("login-module", attrs.toArray()).appendProperties(lm.getProperties()).close();
        }
        gen.close();
    }

    private static void serializationXmlGenerator(XmlGenerator gen, Config config) {
        SerializationConfig c = config.getSerializationConfig();
        if (c == null) {
            return;
        }
        gen.open("serialization", new Object[0]).node("portable-version", c.getPortableVersion(), new Object[0]).node("use-native-byte-order", c.isUseNativeByteOrder(), new Object[0]).node("byte-order", c.getByteOrder(), new Object[0]).node("enable-compression", c.isEnableCompression(), new Object[0]).node("enable-shared-object", c.isEnableSharedObject(), new Object[0]).node("allow-unsafe", c.isAllowUnsafe(), new Object[0]).node("allow-override-default-serializers", c.isAllowOverrideDefaultSerializers(), new Object[0]);
        Map<Integer, String> dsfClasses = c.getDataSerializableFactoryClasses();
        Map<Integer, DataSerializableFactory> dsfImpls = c.getDataSerializableFactories();
        if (!MapUtil.isNullOrEmpty(dsfClasses) || !MapUtil.isNullOrEmpty(dsfImpls)) {
            gen.open("data-serializable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfImpls);
            gen.close();
        }
        Map<Integer, String> portableClasses = c.getPortableFactoryClasses();
        Map<Integer, PortableFactory> portableImpls = c.getPortableFactories();
        if (!MapUtil.isNullOrEmpty(portableClasses) || !MapUtil.isNullOrEmpty(portableImpls)) {
            gen.open("portable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableImpls);
            gen.close();
        }
        Collection<SerializerConfig> serializers = c.getSerializerConfigs();
        GlobalSerializerConfig globalSerializerConfig = c.getGlobalSerializerConfig();
        if (CollectionUtil.isNotEmpty(serializers) || globalSerializerConfig != null) {
            gen.open("serializers", new Object[0]);
            if (globalSerializerConfig != null) {
                gen.node("global-serializer", DynamicConfigXmlGenerator.classNameOrImplClass(globalSerializerConfig.getClassName(), globalSerializerConfig.getImplementation()), "override-java-serialization", globalSerializerConfig.isOverrideJavaSerialization());
            }
            if (CollectionUtil.isNotEmpty(serializers)) {
                for (SerializerConfig serializer : serializers) {
                    gen.node("serializer", null, "type-class", ConfigXmlGenerator.classNameOrClass(serializer.getTypeClassName(), serializer.getTypeClass()), "class-name", DynamicConfigXmlGenerator.classNameOrImplClass(serializer.getClassName(), serializer.getImplementation()));
                }
            }
            gen.close();
        }
        gen.node("check-class-def-errors", c.isCheckClassDefErrors(), new Object[0]);
        JavaSerializationFilterConfig javaSerializationFilterConfig = c.getJavaSerializationFilterConfig();
        if (javaSerializationFilterConfig != null) {
            gen.open("java-serialization-filter", "defaults-disabled", javaSerializationFilterConfig.isDefaultsDisabled());
            ConfigXmlGenerator.appendFilterList(gen, "blacklist", javaSerializationFilterConfig.getBlacklist());
            ConfigXmlGenerator.appendFilterList(gen, "whitelist", javaSerializationFilterConfig.getWhitelist());
            gen.close();
        }
        ConfigXmlGenerator.compactSerializationXmlGenerator(gen, c);
        gen.close();
    }

    private static void compactSerializationXmlGenerator(XmlGenerator gen, SerializationConfig serializationConfig) {
        CompactSerializationConfig compactSerializationConfig = serializationConfig.getCompactSerializationConfig();
        if (!compactSerializationConfig.isEnabled()) {
            return;
        }
        gen.open("compact-serialization", "enabled", compactSerializationConfig.isEnabled());
        Map<String, TriTuple<Class, String, CompactSerializer>> registries = CompactSerializationConfigAccessor.getRegistrations(compactSerializationConfig);
        Map<String, TriTuple<String, String, String>> namedRegistries = CompactSerializationConfigAccessor.getNamedRegistrations(compactSerializationConfig);
        if (!MapUtil.isNullOrEmpty(registries) || !MapUtil.isNullOrEmpty(namedRegistries)) {
            gen.open("registered-classes", new Object[0]);
            ConfigXmlGenerator.appendRegisteredClasses(gen, registries);
            ConfigXmlGenerator.appendNamedRegisteredClasses(gen, namedRegistries);
            gen.close();
        }
        gen.close();
    }

    private static String classNameOrClass(String className, Class clazz) {
        return !StringUtil.isNullOrEmpty(className) ? className : (clazz != null ? clazz.getName() : null);
    }

    private static void partitionGroupXmlGenerator(XmlGenerator gen, Config config) {
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg == null) {
            return;
        }
        gen.open("partition-group", new Object[]{"enabled", pg.isEnabled(), "group-type", pg.getGroupType()});
        Collection<MemberGroupConfig> configs = pg.getMemberGroupConfigs();
        if (CollectionUtil.isNotEmpty(configs)) {
            for (MemberGroupConfig mgConfig : configs) {
                gen.open("member-group", new Object[0]);
                for (String iface : mgConfig.getInterfaces()) {
                    gen.node("interface", iface, new Object[0]);
                }
                gen.close();
            }
        }
        gen.close();
    }

    private void networkConfigXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        NetworkConfig netCfg = config.getNetworkConfig();
        gen.open("network", new Object[0]).node("public-address", netCfg.getPublicAddress(), new Object[0]).node("port", netCfg.getPort(), "port-count", netCfg.getPortCount(), "auto-increment", netCfg.isPortAutoIncrement()).node("reuse-address", netCfg.isReuseAddress(), new Object[0]);
        Collection<String> outboundPortDefinitions = netCfg.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            gen.open("outbound-ports", new Object[0]);
            for (String def : outboundPortDefinitions) {
                gen.node("ports", def, new Object[0]);
            }
            gen.close();
        }
        JoinConfig join = netCfg.getJoin();
        gen.open("join", new Object[0]);
        ConfigXmlGenerator.autoDetectionConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.multicastConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.tcpConfigXmlGenerator(gen, join);
        DynamicConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        DynamicConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, join.getDiscoveryConfig());
        gen.close();
        ConfigXmlGenerator.interfacesConfigXmlGenerator(gen, netCfg.getInterfaces());
        this.sslConfigXmlGenerator(gen, netCfg.getSSLConfig());
        ConfigXmlGenerator.socketInterceptorConfigXmlGenerator(gen, netCfg.getSocketInterceptorConfig());
        this.symmetricEncInterceptorConfigXmlGenerator(gen, netCfg.getSymmetricEncryptionConfig());
        ConfigXmlGenerator.memberAddressProviderConfigXmlGenerator(gen, netCfg.getMemberAddressProviderConfig());
        ConfigXmlGenerator.failureDetectorConfigXmlGenerator(gen, netCfg.getIcmpFailureDetectorConfig());
        ConfigXmlGenerator.restApiXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.memcacheProtocolXmlGenerator(gen, netCfg);
        gen.close();
    }

    private void advancedNetworkConfigXmlGenerator(XmlGenerator gen, Config config) {
        AdvancedNetworkConfig netCfg = config.getAdvancedNetworkConfig();
        if (!netCfg.isEnabled()) {
            return;
        }
        gen.open("advanced-network", "enabled", netCfg.isEnabled());
        JoinConfig join = netCfg.getJoin();
        gen.open("join", new Object[0]);
        ConfigXmlGenerator.autoDetectionConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.multicastConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.tcpConfigXmlGenerator(gen, join);
        DynamicConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        DynamicConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, join.getDiscoveryConfig());
        gen.close();
        ConfigXmlGenerator.failureDetectorConfigXmlGenerator(gen, netCfg.getIcmpFailureDetectorConfig());
        ConfigXmlGenerator.memberAddressProviderConfigXmlGenerator(gen, netCfg.getMemberAddressProviderConfig());
        for (EndpointConfig endpointConfig : netCfg.getEndpointConfigs().values()) {
            this.endpointConfigXmlGenerator(gen, endpointConfig);
        }
        gen.close();
    }

    private void endpointConfigXmlGenerator(XmlGenerator gen, EndpointConfig endpointConfig) {
        if (endpointConfig.getName() != null) {
            gen.open(this.endpointConfigElementName(endpointConfig), "name", endpointConfig.getName());
        } else {
            gen.open(this.endpointConfigElementName(endpointConfig), new Object[0]);
        }
        Collection<String> outboundPortDefinitions = endpointConfig.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            gen.open("outbound-ports", new Object[0]);
            for (String def : outboundPortDefinitions) {
                gen.node("ports", def, new Object[0]);
            }
            gen.close();
        }
        ConfigXmlGenerator.interfacesConfigXmlGenerator(gen, endpointConfig.getInterfaces());
        this.sslConfigXmlGenerator(gen, endpointConfig.getSSLConfig());
        ConfigXmlGenerator.socketInterceptorConfigXmlGenerator(gen, endpointConfig.getSocketInterceptorConfig());
        this.symmetricEncInterceptorConfigXmlGenerator(gen, endpointConfig.getSymmetricEncryptionConfig());
        if (endpointConfig instanceof RestServerEndpointConfig) {
            RestServerEndpointConfig rsec = (RestServerEndpointConfig)endpointConfig;
            gen.open("endpoint-groups", new Object[0]);
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                gen.node("endpoint-group", null, "name", group.name(), "enabled", rsec.isGroupEnabled(group));
            }
            gen.close();
        }
        gen.open("socket-options", new Object[0]);
        gen.node("buffer-direct", endpointConfig.isSocketBufferDirect(), new Object[0]);
        gen.node("tcp-no-delay", endpointConfig.isSocketTcpNoDelay(), new Object[0]);
        gen.node("keep-alive", endpointConfig.isSocketKeepAlive(), new Object[0]);
        gen.node("connect-timeout-seconds", endpointConfig.getSocketConnectTimeoutSeconds(), new Object[0]);
        gen.node("send-buffer-size-kb", endpointConfig.getSocketSendBufferSizeKb(), new Object[0]);
        gen.node("receive-buffer-size-kb", endpointConfig.getSocketRcvBufferSizeKb(), new Object[0]);
        gen.node("linger-seconds", endpointConfig.getSocketLingerSeconds(), new Object[0]);
        gen.close();
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            ServerSocketEndpointConfig serverSocketEndpointConfig = (ServerSocketEndpointConfig)endpointConfig;
            gen.node("port", serverSocketEndpointConfig.getPort(), "port-count", serverSocketEndpointConfig.getPortCount(), "auto-increment", serverSocketEndpointConfig.isPortAutoIncrement()).node("public-address", serverSocketEndpointConfig.getPublicAddress(), new Object[0]).node("reuse-address", serverSocketEndpointConfig.isReuseAddress(), new Object[0]);
        }
        gen.close();
    }

    private String endpointConfigElementName(EndpointConfig endpointConfig) {
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            switch (endpointConfig.getProtocolType()) {
                case REST: {
                    return "rest-server-socket-endpoint-config";
                }
                case WAN: {
                    return "wan-server-socket-endpoint-config";
                }
                case CLIENT: {
                    return "client-server-socket-endpoint-config";
                }
                case MEMBER: {
                    return "member-server-socket-endpoint-config";
                }
                case MEMCACHE: {
                    return "memcache-server-socket-endpoint-config";
                }
            }
            throw new IllegalStateException("Not recognised protocol type");
        }
        return "wan-endpoint-config";
    }

    private static void localDeviceConfigXmlGenerator(XmlGenerator gen, Config config) {
        config.getDeviceConfigs().values().stream().filter(DeviceConfig::isLocal).forEach(deviceConfig -> {
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
            Capacity capacity = localDeviceConfig.getCapacity();
            gen.open("local-device", "name", localDeviceConfig.getName()).node("base-dir", localDeviceConfig.getBaseDir().getAbsolutePath(), new Object[0]).node("capacity", null, new Object[]{"unit", capacity.getUnit(), "value", capacity.getValue()}).node("block-size", localDeviceConfig.getBlockSize(), new Object[0]).node("read-io-thread-count", localDeviceConfig.getReadIOThreadCount(), new Object[0]).node("write-io-thread-count", localDeviceConfig.getWriteIOThreadCount(), new Object[0]).close();
        });
    }

    private static void autoDetectionConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        gen.open("auto-detection", "enabled", join.getAutoDetectionConfig().isEnabled()).close();
    }

    private static void multicastConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        MulticastConfig mcConfig = join.getMulticastConfig();
        gen.open("multicast", "enabled", mcConfig.isEnabled(), "loopbackModeEnabled", mcConfig.getLoopbackModeEnabled()).node("multicast-group", mcConfig.getMulticastGroup(), new Object[0]).node("multicast-port", mcConfig.getMulticastPort(), new Object[0]).node("multicast-timeout-seconds", mcConfig.getMulticastTimeoutSeconds(), new Object[0]).node("multicast-time-to-live", mcConfig.getMulticastTimeToLive(), new Object[0]);
        ConfigXmlGenerator.trustedInterfacesXmlGenerator(gen, mcConfig.getTrustedInterfaces());
        gen.close();
    }

    private static void trustedInterfacesXmlGenerator(XmlGenerator gen, Set<String> trustedInterfaces) {
        if (!trustedInterfaces.isEmpty()) {
            gen.open("trusted-interfaces", new Object[0]);
            for (String trustedInterface : trustedInterfaces) {
                gen.node("interface", trustedInterface, new Object[0]);
            }
            gen.close();
        }
    }

    private static void tcpConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        TcpIpConfig c = join.getTcpIpConfig();
        gen.open("tcp-ip", "enabled", c.isEnabled(), "connection-timeout-seconds", c.getConnectionTimeoutSeconds()).open("member-list", new Object[0]);
        for (String m : c.getMembers()) {
            gen.node("member", m, new Object[0]);
        }
        gen.close().node("required-member", c.getRequiredMember(), new Object[0]).close();
    }

    private static void interfacesConfigXmlGenerator(XmlGenerator gen, InterfacesConfig interfaces) {
        gen.open("interfaces", "enabled", interfaces.isEnabled());
        for (String i : interfaces.getInterfaces()) {
            gen.node("interface", i, new Object[0]);
        }
        gen.close();
    }

    private void sslConfigXmlGenerator(XmlGenerator gen, SSLConfig ssl) {
        if (ssl != null) {
            String factoryClassName = DynamicConfigXmlGenerator.classNameOrImplClass((ssl = new SSLConfig(ssl)).getFactoryClassName(), ssl.getFactoryImplementation());
            if (factoryClassName != null) {
                ssl.setFactoryClassName(factoryClassName);
            }
            Properties props = ssl.getProperties();
            if (this.maskSensitiveFields && props.containsKey("trustStorePassword")) {
                props.setProperty("trustStorePassword", MASK_FOR_SENSITIVE_DATA);
            }
            if (this.maskSensitiveFields && props.containsKey("keyStorePassword")) {
                props.setProperty("keyStorePassword", MASK_FOR_SENSITIVE_DATA);
            }
        }
        this.factoryWithPropertiesXmlGenerator(gen, "ssl", ssl);
    }

    protected void factoryWithPropertiesXmlGenerator(XmlGenerator gen, String elementName, AbstractFactoryWithPropertiesConfig<?> factoryWithProps) {
        gen.open(elementName, "enabled", factoryWithProps != null && factoryWithProps.isEnabled());
        if (factoryWithProps != null) {
            gen.node("factory-class-name", factoryWithProps.getFactoryClassName(), new Object[0]).appendProperties(factoryWithProps.getProperties());
        }
        gen.close();
    }

    private static void socketInterceptorConfigXmlGenerator(XmlGenerator gen, SocketInterceptorConfig socket) {
        gen.open("socket-interceptor", "enabled", socket != null && socket.isEnabled());
        if (socket != null) {
            gen.node("class-name", DynamicConfigXmlGenerator.classNameOrImplClass(socket.getClassName(), socket.getImplementation()), new Object[0]).appendProperties(socket.getProperties());
        }
        gen.close();
    }

    private void commonSymmetricEncInterceptorConfigXmlBodyGenerator(XmlGenerator gen, AbstractSymmetricEncryptionConfig sec) {
        if (sec == null) {
            return;
        }
        gen.node("algorithm", sec.getAlgorithm(), new Object[0]).node("salt", this.getOrMaskValue(sec.getSalt()), new Object[0]);
    }

    private void symmetricEncInterceptorConfigXmlGenerator(XmlGenerator gen, SymmetricEncryptionConfig sec) {
        if (sec == null) {
            return;
        }
        gen.open("symmetric-encryption", "enabled", sec.isEnabled());
        this.commonSymmetricEncInterceptorConfigXmlBodyGenerator(gen, sec);
        gen.node("password", this.getOrMaskValue(sec.getPassword()), new Object[0]).node("iteration-count", sec.getIterationCount(), new Object[0]);
        gen.close();
    }

    private static void memberAddressProviderConfigXmlGenerator(XmlGenerator gen, MemberAddressProviderConfig memberAddressProviderConfig) {
        if (memberAddressProviderConfig == null) {
            return;
        }
        String className = DynamicConfigXmlGenerator.classNameOrImplClass(memberAddressProviderConfig.getClassName(), memberAddressProviderConfig.getImplementation());
        if (StringUtil.isNullOrEmpty(className)) {
            return;
        }
        gen.open("member-address-provider", "enabled", memberAddressProviderConfig.isEnabled()).node("class-name", className, new Object[0]).appendProperties(memberAddressProviderConfig.getProperties()).close();
    }

    private static void failureDetectorConfigXmlGenerator(XmlGenerator gen, IcmpFailureDetectorConfig icmpFailureDetectorConfig) {
        if (icmpFailureDetectorConfig == null) {
            return;
        }
        gen.open("failure-detector", new Object[0]);
        gen.open("icmp", "enabled", icmpFailureDetectorConfig.isEnabled()).node("ttl", icmpFailureDetectorConfig.getTtl(), new Object[0]).node("interval-milliseconds", icmpFailureDetectorConfig.getIntervalMilliseconds(), new Object[0]).node("max-attempts", icmpFailureDetectorConfig.getMaxAttempts(), new Object[0]).node("timeout-milliseconds", icmpFailureDetectorConfig.getTimeoutMilliseconds(), new Object[0]).node("fail-fast-on-startup", icmpFailureDetectorConfig.isFailFastOnStartup(), new Object[0]).node("parallel-mode", icmpFailureDetectorConfig.isParallelMode(), new Object[0]).close();
        gen.close();
    }

    private void persistenceXmlGenerator(XmlGenerator gen, Config config) {
        PersistenceConfig prCfg = config.getPersistenceConfig();
        if (prCfg == null) {
            gen.node("persistence", "enabled", "false");
            return;
        }
        gen.open("persistence", "enabled", prCfg.isEnabled()).node("base-dir", prCfg.getBaseDir().getAbsolutePath(), new Object[0]);
        if (prCfg.getBackupDir() != null) {
            gen.node("backup-dir", prCfg.getBackupDir().getAbsolutePath(), new Object[0]);
        }
        gen.node("parallelism", prCfg.getParallelism(), new Object[0]).node("validation-timeout-seconds", prCfg.getValidationTimeoutSeconds(), new Object[0]).node("data-load-timeout-seconds", prCfg.getDataLoadTimeoutSeconds(), new Object[0]).node("cluster-data-recovery-policy", (Object)prCfg.getClusterDataRecoveryPolicy(), new Object[0]).node("auto-remove-stale-data", prCfg.isAutoRemoveStaleData(), new Object[0]).node("rebalance-delay-seconds", prCfg.getRebalanceDelaySeconds(), new Object[0]);
        this.encryptionAtRestXmlGenerator(gen, prCfg.getEncryptionAtRestConfig());
        gen.close();
    }

    private void dynamicConfigurationXmlGenerator(XmlGenerator gen, Config config) {
        DynamicConfigurationConfig dynamicConfigurationConfig = config.getDynamicConfigurationConfig();
        gen.open("dynamic-configuration", new Object[0]).node("persistence-enabled", dynamicConfigurationConfig.isPersistenceEnabled(), new Object[0]);
        if (dynamicConfigurationConfig.getBackupDir() != null) {
            gen.node("backup-dir", dynamicConfigurationConfig.getBackupDir().getAbsolutePath(), new Object[0]);
        }
        gen.node("backup-count", dynamicConfigurationConfig.getBackupCount(), new Object[0]);
        gen.close();
    }

    private void encryptionAtRestXmlGenerator(XmlGenerator gen, EncryptionAtRestConfig encryptionAtRestConfig) {
        if (encryptionAtRestConfig == null) {
            gen.node("encryption-at-rest", "enabled", "false");
            return;
        }
        gen.open("encryption-at-rest", "enabled", encryptionAtRestConfig.isEnabled()).node("key-size", encryptionAtRestConfig.getKeySize(), new Object[0]);
        this.commonSymmetricEncInterceptorConfigXmlBodyGenerator(gen, encryptionAtRestConfig);
        this.secureStoreXmlGenerator(gen, encryptionAtRestConfig.getSecureStoreConfig());
        gen.close();
    }

    private void secureStoreXmlGenerator(XmlGenerator gen, SecureStoreConfig secureStoreConfig) {
        if (secureStoreConfig != null) {
            gen.open("secure-store", new Object[0]);
            if (secureStoreConfig instanceof JavaKeyStoreSecureStoreConfig) {
                this.javaKeyStoreSecureStoreXmlGenerator(gen, (JavaKeyStoreSecureStoreConfig)secureStoreConfig);
            } else if (secureStoreConfig instanceof VaultSecureStoreConfig) {
                this.vaultSecureStoreXmlGenerator(gen, (VaultSecureStoreConfig)secureStoreConfig);
            }
            gen.close();
        }
    }

    private void javaKeyStoreSecureStoreXmlGenerator(XmlGenerator gen, JavaKeyStoreSecureStoreConfig secureStoreConfig) {
        gen.open("keystore", new Object[0]).node("path", secureStoreConfig.getPath().getAbsolutePath(), new Object[0]).node("type", secureStoreConfig.getType(), new Object[0]).node("password", this.getOrMaskValue(secureStoreConfig.getPassword()), new Object[0]).node("polling-interval", secureStoreConfig.getPollingInterval(), new Object[0]).node("current-key-alias", secureStoreConfig.getCurrentKeyAlias(), new Object[0]);
        gen.close();
    }

    private void vaultSecureStoreXmlGenerator(XmlGenerator gen, VaultSecureStoreConfig secureStoreConfig) {
        gen.open("vault", new Object[0]).node("address", secureStoreConfig.getAddress(), new Object[0]).node("secret-path", secureStoreConfig.getSecretPath(), new Object[0]).node("token", this.getOrMaskValue(secureStoreConfig.getToken()), new Object[0]).node("polling-interval", secureStoreConfig.getPollingInterval(), new Object[0]);
        this.sslConfigXmlGenerator(gen, secureStoreConfig.getSSLConfig());
        gen.close();
    }

    private static void crdtReplicationXmlGenerator(XmlGenerator gen, Config config) {
        CRDTReplicationConfig replicationConfig = config.getCRDTReplicationConfig();
        gen.open("crdt-replication", new Object[0]);
        if (replicationConfig != null) {
            gen.node("replication-period-millis", replicationConfig.getReplicationPeriodMillis(), new Object[0]).node("max-concurrent-replication-targets", replicationConfig.getMaxConcurrentReplicationTargets(), new Object[0]);
        }
        gen.close();
    }

    private static void splitBrainProtectionXmlGenerator(XmlGenerator gen, Config config) {
        for (SplitBrainProtectionConfig splitBrainProtectionConfig : config.getSplitBrainProtectionConfigs().values()) {
            gen.open("split-brain-protection", "name", splitBrainProtectionConfig.getName(), "enabled", splitBrainProtectionConfig.isEnabled()).node("minimum-cluster-size", splitBrainProtectionConfig.getMinimumClusterSize(), new Object[0]).node("protect-on", (Object)splitBrainProtectionConfig.getProtectOn(), new Object[0]);
            if (!splitBrainProtectionConfig.getListenerConfigs().isEmpty()) {
                gen.open("listeners", new Object[0]);
                for (SplitBrainProtectionListenerConfig listenerConfig : splitBrainProtectionConfig.getListenerConfigs()) {
                    gen.node("listener", DynamicConfigXmlGenerator.classNameOrImplClass(listenerConfig.getClassName(), listenerConfig.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            ConfigXmlGenerator.handleSplitBrainProtectionFunction(gen, splitBrainProtectionConfig);
            gen.close();
        }
    }

    private static void cpSubsystemConfig(XmlGenerator gen, Config config) {
        CPSubsystemConfig cpSubsystemConfig = config.getCPSubsystemConfig();
        gen.open("cp-subsystem", new Object[0]).node("cp-member-count", cpSubsystemConfig.getCPMemberCount(), new Object[0]).node("group-size", cpSubsystemConfig.getGroupSize(), new Object[0]).node("session-time-to-live-seconds", cpSubsystemConfig.getSessionTimeToLiveSeconds(), new Object[0]).node("session-heartbeat-interval-seconds", cpSubsystemConfig.getSessionHeartbeatIntervalSeconds(), new Object[0]).node("missing-cp-member-auto-removal-seconds", cpSubsystemConfig.getMissingCPMemberAutoRemovalSeconds(), new Object[0]).node("fail-on-indeterminate-operation-state", cpSubsystemConfig.isFailOnIndeterminateOperationState(), new Object[0]).node("persistence-enabled", cpSubsystemConfig.isPersistenceEnabled(), new Object[0]).node("base-dir", cpSubsystemConfig.getBaseDir().getAbsolutePath(), new Object[0]).node("data-load-timeout-seconds", cpSubsystemConfig.getDataLoadTimeoutSeconds(), new Object[0]);
        RaftAlgorithmConfig raftAlgorithmConfig = cpSubsystemConfig.getRaftAlgorithmConfig();
        gen.open("raft-algorithm", new Object[0]).node("leader-election-timeout-in-millis", raftAlgorithmConfig.getLeaderElectionTimeoutInMillis(), new Object[0]).node("leader-heartbeat-period-in-millis", raftAlgorithmConfig.getLeaderHeartbeatPeriodInMillis(), new Object[0]).node("max-missed-leader-heartbeat-count", raftAlgorithmConfig.getMaxMissedLeaderHeartbeatCount(), new Object[0]).node("append-request-max-entry-count", raftAlgorithmConfig.getAppendRequestMaxEntryCount(), new Object[0]).node("commit-index-advance-count-to-snapshot", raftAlgorithmConfig.getCommitIndexAdvanceCountToSnapshot(), new Object[0]).node("uncommitted-entry-count-to-reject-new-appends", raftAlgorithmConfig.getUncommittedEntryCountToRejectNewAppends(), new Object[0]).node("append-request-backoff-timeout-in-millis", raftAlgorithmConfig.getAppendRequestBackoffTimeoutInMillis(), new Object[0]).close();
        gen.open("semaphores", new Object[0]);
        for (SemaphoreConfig semaphoreConfig : cpSubsystemConfig.getSemaphoreConfigs().values()) {
            gen.open("semaphore", new Object[0]).node("name", semaphoreConfig.getName(), new Object[0]).node("jdk-compatible", semaphoreConfig.isJDKCompatible(), new Object[0]).node("initial-permits", semaphoreConfig.getInitialPermits(), new Object[0]).close();
        }
        gen.close().open("locks", new Object[0]);
        for (FencedLockConfig lockConfig : cpSubsystemConfig.getLockConfigs().values()) {
            gen.open("fenced-lock", new Object[0]).node("name", lockConfig.getName(), new Object[0]).node("lock-acquire-limit", lockConfig.getLockAcquireLimit(), new Object[0]).close();
        }
        gen.close().close();
    }

    private static void instanceTrackingConfig(XmlGenerator gen, Config config) {
        InstanceTrackingConfig trackingConfig = config.getInstanceTrackingConfig();
        gen.open("instance-tracking", "enabled", trackingConfig.isEnabled()).node("file-name", trackingConfig.getFileName(), new Object[0]).node("format-pattern", trackingConfig.getFormatPattern(), new Object[0]).close();
    }

    private static void metricsConfig(XmlGenerator gen, Config config) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        gen.open("metrics", "enabled", metricsConfig.isEnabled()).open("management-center", "enabled", metricsConfig.getManagementCenterConfig().isEnabled()).node("retention-seconds", metricsConfig.getManagementCenterConfig().getRetentionSeconds(), new Object[0]).close().open("jmx", "enabled", metricsConfig.getJmxConfig().isEnabled()).close().node("collection-frequency-seconds", metricsConfig.getCollectionFrequencySeconds(), new Object[0]).close();
    }

    private static void sqlConfig(XmlGenerator gen, Config config) {
        SqlConfig sqlConfig = config.getSqlConfig();
        gen.open("sql", new Object[0]).node("statement-timeout-millis", sqlConfig.getStatementTimeoutMillis(), new Object[0]).close();
    }

    private static void jetConfig(XmlGenerator gen, Config config) {
        JetConfig jetConfig = config.getJetConfig();
        EdgeConfig edgeConfig = jetConfig.getDefaultEdgeConfig();
        gen.open("jet", "enabled", jetConfig.isEnabled(), "resource-upload-enabled", jetConfig.isResourceUploadEnabled()).node("cooperative-thread-count", jetConfig.getCooperativeThreadCount(), new Object[0]).node("flow-control-period", jetConfig.getFlowControlPeriodMs(), new Object[0]).node("backup-count", jetConfig.getBackupCount(), new Object[0]).node("scale-up-delay-millis", jetConfig.getScaleUpDelayMillis(), new Object[0]).node("lossless-restart-enabled", jetConfig.isLosslessRestartEnabled(), new Object[0]).node("max-processor-accumulated-records", jetConfig.getMaxProcessorAccumulatedRecords(), new Object[0]).open("edge-defaults", new Object[0]).node("queue-size", edgeConfig.getQueueSize(), new Object[0]).node("packet-size-limit", edgeConfig.getPacketSizeLimit(), new Object[0]).node("receive-window-multiplier", edgeConfig.getReceiveWindowMultiplier(), new Object[0]).close().close();
    }

    private static void userCodeDeploymentConfig(XmlGenerator gen, Config config) {
        UserCodeDeploymentConfig ucdConfig = config.getUserCodeDeploymentConfig();
        gen.open("user-code-deployment", "enabled", ucdConfig.isEnabled()).node("class-cache-mode", (Object)ucdConfig.getClassCacheMode(), new Object[0]).node("provider-mode", (Object)ucdConfig.getProviderMode(), new Object[0]).node("blacklist-prefixes", ucdConfig.getBlacklistedPrefixes(), new Object[0]).node("whitelist-prefixes", ucdConfig.getWhitelistedPrefixes(), new Object[0]).node("provider-filter", ucdConfig.getProviderFilter(), new Object[0]).close();
    }

    private static void handleSplitBrainProtectionFunction(XmlGenerator gen, SplitBrainProtectionConfig splitBrainProtectionConfig) {
        if (splitBrainProtectionConfig.getFunctionImplementation() instanceof ProbabilisticSplitBrainProtectionFunction) {
            ProbabilisticSplitBrainProtectionFunction qf = (ProbabilisticSplitBrainProtectionFunction)splitBrainProtectionConfig.getFunctionImplementation();
            long acceptableHeartbeatPause = qf.getAcceptableHeartbeatPauseMillis();
            double threshold = qf.getSuspicionThreshold();
            int maxSampleSize = qf.getMaxSampleSize();
            long minStdDeviation = qf.getMinStdDeviationMillis();
            long firstHeartbeatEstimate = qf.getHeartbeatIntervalMillis();
            gen.open("probabilistic-split-brain-protection", "acceptable-heartbeat-pause-millis", acceptableHeartbeatPause, "suspicion-threshold", threshold, "max-sample-size", maxSampleSize, "min-std-deviation-millis", minStdDeviation, "heartbeat-interval-millis", firstHeartbeatEstimate);
            gen.close();
        } else if (splitBrainProtectionConfig.getFunctionImplementation() instanceof RecentlyActiveSplitBrainProtectionFunction) {
            RecentlyActiveSplitBrainProtectionFunction qf = (RecentlyActiveSplitBrainProtectionFunction)splitBrainProtectionConfig.getFunctionImplementation();
            gen.open("recently-active-split-brain-protection", "heartbeat-tolerance-millis", qf.getHeartbeatToleranceMillis());
            gen.close();
        } else {
            gen.node("function-class-name", DynamicConfigXmlGenerator.classNameOrImplClass(splitBrainProtectionConfig.getFunctionClassName(), splitBrainProtectionConfig.getFunctionImplementation()), new Object[0]);
        }
    }

    private static void nativeMemoryXmlGenerator(XmlGenerator gen, Config config) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        if (nativeMemoryConfig == null) {
            gen.node("native-memory", null, "enabled", "false");
            return;
        }
        gen.open("native-memory", new Object[]{"enabled", nativeMemoryConfig.isEnabled(), "allocator-type", nativeMemoryConfig.getAllocatorType()}).node("size", null, new Object[]{"unit", nativeMemoryConfig.getSize().getUnit(), "value", nativeMemoryConfig.getSize().getValue()}).node("min-block-size", nativeMemoryConfig.getMinBlockSize(), new Object[0]).node("page-size", nativeMemoryConfig.getPageSize(), new Object[0]).node("metadata-space-percentage", Float.valueOf(nativeMemoryConfig.getMetadataSpacePercentage()), new Object[0]);
        PersistentMemoryConfig pmemConfig = nativeMemoryConfig.getPersistentMemoryConfig();
        List<PersistentMemoryDirectoryConfig> directoryConfigs = pmemConfig.getDirectoryConfigs();
        gen.open("persistent-memory", "enabled", pmemConfig.isEnabled(), "mode", pmemConfig.getMode().name());
        if (!directoryConfigs.isEmpty()) {
            gen.open("directories", new Object[0]);
            for (PersistentMemoryDirectoryConfig dirConfig : directoryConfigs) {
                if (dirConfig.isNumaNodeSet()) {
                    gen.node("directory", dirConfig.getDirectory(), "numa-node", dirConfig.getNumaNode());
                    continue;
                }
                gen.node("directory", dirConfig.getDirectory(), new Object[0]);
            }
            gen.close();
        }
        gen.close().close();
    }

    private static void liteMemberXmlGenerator(XmlGenerator gen, Config config) {
        gen.node("lite-member", null, "enabled", config.isLiteMember());
    }

    private static void restApiXmlGenerator(XmlGenerator gen, NetworkConfig config) {
        RestApiConfig c = config.getRestApiConfig();
        if (c == null) {
            return;
        }
        gen.open("rest-api", "enabled", c.isEnabled());
        for (RestEndpointGroup group : RestEndpointGroup.values()) {
            gen.node("endpoint-group", null, "name", group.name(), "enabled", c.isGroupEnabled(group));
        }
        gen.close();
    }

    private static void memcacheProtocolXmlGenerator(XmlGenerator gen, NetworkConfig config) {
        MemcacheProtocolConfig c = config.getMemcacheProtocolConfig();
        if (c == null) {
            return;
        }
        gen.node("memcache-protocol", null, "enabled", c.isEnabled());
    }

    private static void appendSerializationFactory(XmlGenerator gen, String elementName, Map<Integer, ?> factoryMap) {
        if (MapUtil.isNullOrEmpty(factoryMap)) {
            return;
        }
        for (Map.Entry<Integer, ?> factory : factoryMap.entrySet()) {
            Object value = factory.getValue();
            String className = value instanceof String ? (String)value : value.getClass().getName();
            gen.node(elementName, className, "factory-id", ((Object)factory.getKey()).toString());
        }
    }

    private static void appendFilterList(XmlGenerator gen, String listName, ClassFilter classFilterList) {
        if (classFilterList.isEmpty()) {
            return;
        }
        gen.open(listName, new Object[0]);
        for (String className : classFilterList.getClasses()) {
            gen.node("class", className, new Object[0]);
        }
        for (String packageName : classFilterList.getPackages()) {
            gen.node("package", packageName, new Object[0]);
        }
        for (String prefix : classFilterList.getPrefixes()) {
            gen.node("prefix", prefix, new Object[0]);
        }
        gen.close();
    }

    private static void appendRegisteredClasses(XmlGenerator gen, Map<String, TriTuple<Class, String, CompactSerializer>> registries) {
        if (registries.isEmpty()) {
            return;
        }
        for (TriTuple<Class, String, CompactSerializer> registration : registries.values()) {
            Class registeredClass = (Class)registration.element1;
            String typeName = (String)registration.element2;
            CompactSerializer serializer = (CompactSerializer)registration.element3;
            if (serializer != null) {
                String serializerClassName = serializer.getClass().getName();
                gen.node("class", registeredClass.getName(), "type-name", typeName, "serializer", serializerClassName);
                continue;
            }
            gen.node("class", registeredClass.getName(), new Object[0]);
        }
    }

    private static void appendNamedRegisteredClasses(XmlGenerator gen, Map<String, TriTuple<String, String, String>> namedRegistries) {
        if (namedRegistries.isEmpty()) {
            return;
        }
        for (TriTuple<String, String, String> registration : namedRegistries.values()) {
            String registeredClassName = (String)registration.element1;
            String typeName = (String)registration.element2;
            String serializerClassName = (String)registration.element3;
            if (serializerClassName != null) {
                gen.node("class", registeredClassName, "type-name", typeName, "serializer", serializerClassName);
                continue;
            }
            gen.node("class", registeredClassName, new Object[0]);
        }
    }

    private static void integrityCheckerXmlGenerator(XmlGenerator gen, Config config) {
        gen.node("integrity-checker", null, "enabled", config.getIntegrityCheckerConfig().isEnabled());
    }

    public static final class XmlGenerator {
        private static final int CAPACITY = 64;
        private final StringBuilder xml;
        private final ArrayDeque<String> openNodes = new ArrayDeque();

        public XmlGenerator(StringBuilder xml) {
            this.xml = xml;
        }

        public XmlGenerator open(String name, Object ... attributes) {
            XmlGenerator.appendOpenNode(this.xml, name, attributes);
            this.openNodes.addLast(name);
            return this;
        }

        public XmlGenerator node(String name, Object contents, Object ... attributes) {
            XmlGenerator.appendNode(this.xml, name, contents, attributes);
            return this;
        }

        public XmlGenerator nodeIfContents(String name, Object contents, Object ... attributes) {
            if (contents != null) {
                XmlGenerator.appendNode(this.xml, name, contents, attributes);
            }
            return this;
        }

        public XmlGenerator close() {
            XmlGenerator.appendCloseNode(this.xml, this.openNodes.pollLast());
            return this;
        }

        public XmlGenerator appendLabels(Set<String> labels) {
            if (!labels.isEmpty()) {
                this.open("client-labels", new Object[0]);
                for (String label : labels) {
                    this.node("label", label, new Object[0]);
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Properties props) {
            if (!props.isEmpty()) {
                this.open("properties", new Object[0]);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    this.node("property", props.getProperty(key.toString()), "name", key.toString());
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Map<String, ? extends Comparable> props) {
            if (!MapUtil.isNullOrEmpty(props)) {
                this.open("properties", new Object[0]);
                for (Map.Entry<String, ? extends Comparable> entry : props.entrySet()) {
                    this.node("property", entry.getValue(), "name", entry.getKey());
                }
                this.close();
            }
            return this;
        }

        private static void appendOpenNode(StringBuilder xml, String name, Object ... attributes) {
            xml.append('<').append(name);
            XmlGenerator.appendAttributes(xml, attributes);
            xml.append('>');
        }

        private static void appendCloseNode(StringBuilder xml, String name) {
            xml.append("</").append(name).append('>');
        }

        private static void appendNode(StringBuilder xml, String name, Object contents, Object ... attributes) {
            if (contents != null || attributes.length > 0) {
                xml.append('<').append(name);
                XmlGenerator.appendAttributes(xml, attributes);
                if (contents != null) {
                    xml.append('>');
                    XmlGenerator.escapeXml(contents, xml);
                    xml.append("</").append(name).append('>');
                } else {
                    xml.append("/>");
                }
            }
        }

        private static void appendAttributes(StringBuilder xml, Object ... attributes) {
            int i = 0;
            while (i < attributes.length) {
                Object attributeValue;
                Object attributeName = attributes[i++];
                if ((attributeValue = attributes[i++]) == null) continue;
                xml.append(" ").append(attributeName).append("=\"");
                XmlGenerator.escapeXmlAttr(attributeValue, xml);
                xml.append("\"");
            }
        }

        private static void escapeXml(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s2 = o.toString();
            int length = s2.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            for (int i = 0; i < length; ++i) {
                char ch = s2.charAt(i);
                if (ch == '<') {
                    appendTo.append("&lt;");
                    continue;
                }
                if (ch == '&') {
                    appendTo.append("&amp;");
                    continue;
                }
                appendTo.append(ch);
            }
        }

        private static void escapeXmlAttr(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s2 = o.toString();
            int length = s2.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            block6: for (int i = 0; i < length; ++i) {
                char ch = s2.charAt(i);
                switch (ch) {
                    case '\"': {
                        appendTo.append("&quot;");
                        continue block6;
                    }
                    case '\'': {
                        appendTo.append("&#39;");
                        continue block6;
                    }
                    case '&': {
                        appendTo.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        appendTo.append("&lt;");
                        continue block6;
                    }
                    default: {
                        appendTo.append(ch);
                    }
                }
            }
        }
    }
}

