/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddDistributedObjectListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.proxyservice.ProxyService;
import java.security.Permission;
import java.util.UUID;

public class AddDistributedObjectListenerMessageTask
extends AbstractCallableMessageTask<Boolean>
implements DistributedObjectListener {
    public AddDistributedObjectListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        ProxyService proxyService = this.clientEngine.getProxyService();
        UUID registrationId = proxyService.addProxyListener(this);
        this.endpoint.addDestroyAction(registrationId, () -> proxyService.removeProxyListener(registrationId));
        return registrationId;
    }

    @Override
    protected Boolean decodeClientMessage(ClientMessage clientMessage) {
        return ClientAddDistributedObjectListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientAddDistributedObjectListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:proxyService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "addDistributedObjectListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public void distributedObjectCreated(DistributedObjectEvent event) {
        this.send(event);
    }

    @Override
    public void distributedObjectDestroyed(DistributedObjectEvent event) {
        this.send(event);
    }

    @Override
    protected boolean acceptOnIncompleteStart() {
        return true;
    }

    private void send(DistributedObjectEvent event) {
        if (!this.shouldSendEvent()) {
            return;
        }
        String name = (String)event.getObjectName();
        String serviceName = event.getServiceName();
        ClientMessage eventMessage = ClientAddDistributedObjectListenerCodec.encodeDistributedObjectEvent(name, serviceName, event.getEventType().name(), (UUID)event.getSource());
        this.sendClientMessage(null, eventMessage);
    }

    private boolean shouldSendEvent() {
        if (!this.endpoint.isAlive()) {
            return false;
        }
        ClusterService clusterService = this.clientEngine.getClusterService();
        boolean currentMemberIsMaster = clusterService.isMaster();
        return (Boolean)this.parameters == false || currentMemberIsMaster;
    }
}

