/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.core.flink.config;

/**
 * Flink run mode, used to determine whether to run in local or cluster mode.
 * <a href="https://flink.apache.org/news/2020/07/14/application-mode.html">application-mode</a>
 */
public enum FlinkRunMode {
    RUN("run"),
    APPLICATION_RUN("run-application"),
    ;

    private final String mode;

    FlinkRunMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return mode;
    }

    public String toString() {

        return "FlinkRunMode{" +
            "mode='" + mode + '\'' +
            '}';
    }
}
