/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.Objects;

public final class TablePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;

    private TablePath(String databaseName, String tableName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public static TablePath of(String fullName) {
        String[] paths = fullName.split("\\.");
        if (paths.length != 2) {
            throw new IllegalArgumentException(String.format("Cannot get split '%s' to get databaseName and tableName", fullName));
        }
        return new TablePath(paths[0], paths[1]);
    }

    public static TablePath of(String databaseName, String tableName) {
        return new TablePath(databaseName, tableName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullName() {
        return String.format("%s.%s", this.databaseName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TablePath that = (TablePath)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName);
    }

    public String toString() {
        return this.getFullName();
    }
}

