/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.engine.common.utils.ConsumerWithException;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.AbstractFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneOutputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class IntermediateQueueFlowLifeCycle
extends AbstractFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>>,
OneOutputFlowLifeCycle<Record<?>> {
    private final BlockingQueue<Record<?>> queue;

    public IntermediateQueueFlowLifeCycle(SeaTunnelTask runningTask, CompletableFuture<Void> completableFuture, BlockingQueue<Record<?>> queue) {
        super(runningTask, completableFuture);
        this.queue = queue;
    }

    @Override
    public void received(Record<?> record) {
        try {
            this.handleRecord(record, this.queue::put);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void collect(Collector<Record<?>> collector) throws Exception {
        Record record;
        while ((record = (Record)this.queue.poll()) != null) {
            this.handleRecord(record, collector::collect);
        }
    }

    private void handleRecord(Record<?> record, ConsumerWithException<Record<?>> consumer) throws Exception {
        if (record.getData() instanceof Barrier) {
            CheckpointBarrier barrier = (CheckpointBarrier)record.getData();
            this.runningTask.ack(barrier);
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            consumer.accept(record);
        } else {
            if (this.prepareClose.booleanValue()) {
                return;
            }
            consumer.accept(record);
        }
    }
}

