/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.context;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.source.AssignSplitOperation;

public class SeaTunnelSplitEnumeratorContext<SplitT extends SourceSplit>
implements SourceSplitEnumerator.Context<SplitT> {
    private final int parallelism;
    private final SourceSplitEnumeratorTask<SplitT> task;

    public SeaTunnelSplitEnumeratorContext(int parallelism, SourceSplitEnumeratorTask<SplitT> task) {
        this.parallelism = parallelism;
        this.task = task;
    }

    @Override
    public int currentParallelism() {
        return this.parallelism;
    }

    @Override
    public Set<Integer> registeredReaders() {
        return new HashSet<Integer>(this.task.getRegisteredReaders());
    }

    @Override
    public void assignSplit(int subtaskIndex, List<SplitT> splits) {
        this.task.getExecutionContext().sendToMember(new AssignSplitOperation(this.task.getTaskMemberLocationByIndex(subtaskIndex), SerializationUtils.serialize(splits.toArray())), this.task.getTaskMemberAddressByIndex(subtaskIndex));
    }

    @Override
    public void signalNoMoreSplits(int subtaskIndex) {
        this.task.getExecutionContext().sendToMember(new AssignSplitOperation(this.task.getTaskMemberLocationByIndex(subtaskIndex), SerializationUtils.serialize(Collections.emptyList().toArray())), this.task.getTaskMemberAddressByIndex(subtaskIndex));
    }

    @Override
    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
    }
}

