/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.util.List;

public class IndexFilterValue
implements IdentifiedDataSerializable {
    private List<Expression> components;
    private List<Boolean> allowNulls;

    public IndexFilterValue() {
    }

    public IndexFilterValue(List<Expression> components, List<Boolean> allowNulls) {
        this.components = components;
        this.allowNulls = allowNulls;
    }

    public Comparable getValue(ExpressionEvalContext evalContext) {
        if (this.components.size() == 1) {
            return this.getComponentValue(0, evalContext);
        }
        Comparable[] componentValues = new Comparable[this.components.size()];
        for (int i = 0; i < this.components.size(); ++i) {
            Comparable componentValue = this.getComponentValue(i, evalContext);
            if (componentValue == null) {
                return null;
            }
            componentValues[i] = componentValue;
        }
        return new CompositeValue(componentValues);
    }

    private Comparable getComponentValue(int index, ExpressionEvalContext evalContext) {
        Object value = this.components.get(index).evalTop(NoColumnAccessRow.INSTANCE, evalContext);
        if (value == null && this.allowNulls.get(index).booleanValue()) {
            value = AbstractIndex.NULL;
        }
        if (value != null && !(value instanceof Comparable)) {
            throw QueryException.dataException("Values used in index lookups must be Comparable: " + value);
        }
        return (Comparable)value;
    }

    public List<Expression> getComponents() {
        return this.components;
    }

    public List<Boolean> getAllowNulls() {
        return this.allowNulls;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeList(this.components, out);
        SerializationUtil.writeList(this.allowNulls, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.components = SerializationUtil.readList(in);
        this.allowNulls = SerializationUtil.readList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFilterValue value = (IndexFilterValue)o;
        return this.components.equals(value.components) && this.allowNulls.equals(value.allowNulls);
    }

    public int hashCode() {
        int result2 = this.components.hashCode();
        result2 = 31 * result2 + this.allowNulls.hashCode();
        return result2;
    }

    public String toString() {
        return "IndexFilterValue {components=" + this.components + ", allowNulls=" + this.allowNulls + '}';
    }

    private static final class NoColumnAccessRow
    implements Row {
        private static final NoColumnAccessRow INSTANCE = new NoColumnAccessRow();

        private NoColumnAccessRow() {
        }

        @Override
        public <T> T get(int index) {
            throw new UnsupportedOperationException("Index filter cannot contain column expressions");
        }

        @Override
        public int getColumnCount() {
            throw new UnsupportedOperationException("Index filter cannot contain column expressions");
        }
    }
}

