/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;

@BinaryInterface
public class UsernamePasswordCredentials
implements PasswordCredentials,
IdentifiedDataSerializable {
    private static final long serialVersionUID = -1508314631354255039L;
    private String name;
    private String password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.name = username;
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    public String toString() {
        return "UsernamePasswordCredentials{name=" + this.name + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.password);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.password = in.readString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.password == null ? 0 : this.password.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsernamePasswordCredentials other = (UsernamePasswordCredentials)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.password == null ? other.password != null : !this.password.equals(other.password));
    }
}

