/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.monitor.impl.EmptyLocalReplicatedMapStats;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ResultSet;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.LocalReplicatedMapStats;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.ClearOperationFactory;
import com.hazelcast.replicatedmap.impl.operation.PutAllOperation;
import com.hazelcast.replicatedmap.impl.operation.PutOperation;
import com.hazelcast.replicatedmap.impl.operation.RemoveOperation;
import com.hazelcast.replicatedmap.impl.operation.RequestMapDataOperation;
import com.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.hazelcast.replicatedmap.impl.record.ReplicatedEntryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedQueryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.InitializingObject;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReplicatedMapProxy<K, V>
extends AbstractDistributedObject<ReplicatedMapService>
implements ReplicatedMap<K, V>,
InitializingObject {
    private static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    private static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private static final String NULL_TIMEUNIT_IS_NOT_ALLOWED = "Null time unit is not allowed!";
    private static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    private static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Null predicate is not allowed!";
    private static final int WAIT_INTERVAL_MILLIS = 1000;
    private static final int RETRY_INTERVAL_COUNT = 3;
    private static final int KEY_SET_MIN_SIZE = 16;
    private static final int KEY_SET_STORE_MULTIPLE = 4;
    private static final int PARALLEL_INIT_REQUESTS_LIMIT = 100;
    private static final LocalReplicatedMapStats EMPTY_LOCAL_MAP_STATS = new EmptyLocalReplicatedMapStats();
    private final String name;
    private final NodeEngine nodeEngine;
    private final ReplicatedMapService service;
    private final ReplicatedMapEventPublishingService eventPublishingService;
    private final SerializationService serializationService;
    private final InternalPartitionServiceImpl partitionService;
    private final ReplicatedMapConfig config;

    ReplicatedMapProxy(NodeEngine nodeEngine, String name, ReplicatedMapService service, ReplicatedMapConfig config) {
        super(nodeEngine, service);
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.service = service;
        this.eventPublishingService = service.getEventPublishingService();
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        this.config = config;
    }

    @Override
    public void initialize() {
        this.service.initializeListeners(this.name);
        if (this.nodeEngine.getClusterService().getSize() == 1) {
            return;
        }
        this.fireMapDataLoadingTasks();
        if (!this.config.isAsyncFillup()) {
            this.syncFill();
        }
    }

    private void syncFill() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        BitSet nonLoadedStores = new BitSet(partitionCount);
        int[] retryCount = new int[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            nonLoadedStores.set(i);
        }
        while (true) {
            int remainingParallelRequests = 100;
            int nonLoadedPartition = nonLoadedStores.nextSetBit(0);
            while (nonLoadedPartition >= 0 && remainingParallelRequests > 0) {
                ReplicatedRecordStore store = this.service.getReplicatedRecordStore(this.name, false, nonLoadedPartition);
                if (store == null || !store.isLoaded()) {
                    int n = nonLoadedPartition;
                    int n2 = retryCount[n];
                    retryCount[n] = n2 + 1;
                    if (n2 % 3 == 0) {
                        this.requestDataForPartition(nonLoadedPartition);
                        --remainingParallelRequests;
                    }
                } else {
                    nonLoadedStores.clear(nonLoadedPartition);
                }
                nonLoadedPartition = nonLoadedStores.nextSetBit(nonLoadedPartition + 1);
            }
            if (nonLoadedStores.isEmpty()) break;
            this.sleep();
        }
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void fireMapDataLoadingTasks() {
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            this.requestDataForPartition(i);
        }
    }

    private void requestDataForPartition(int partitionId) {
        RequestMapDataOperation requestMapDataOperation = new RequestMapDataOperation(this.name);
        OperationService operationService = this.nodeEngine.getOperationService();
        operationService.createInvocationBuilder("hz:impl:replicatedMapService", (Operation)requestMapDataOperation, partitionId).setTryCount(3).invoke();
    }

    @Override
    protected boolean preDestroy() {
        if (super.preDestroy()) {
            this.eventPublishingService.fireMapClearedEvent(this.size(), this.name);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPartitionKey() {
        return this.getName();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public int size() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        int size2 = 0;
        for (ReplicatedRecordStore store : stores) {
            size2 += store.size();
        }
        return size2;
    }

    @Override
    public boolean isEmpty() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        for (ReplicatedRecordStore store : stores) {
            if (store.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        int partitionId = this.partitionService.getPartitionId(key);
        ReplicatedRecordStore store = this.service.getReplicatedRecordStore(this.name, false, partitionId);
        return store != null && store.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        for (ReplicatedRecordStore store : stores) {
            if (!store.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(@Nonnull Object key) {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        int partitionId = this.partitionService.getPartitionId(key);
        ReplicatedRecordStore store = this.service.getReplicatedRecordStore(this.getName(), false, partitionId);
        if (store == null) {
            return null;
        }
        return (V)store.get(key);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data dataKey = this.nodeEngine.toData(key);
        Data dataValue = this.nodeEngine.toData(value);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(dataKey);
        PutOperation putOperation = new PutOperation(this.getName(), dataKey, dataValue);
        InvocationFuture future = this.getOperationService().invokeOnPartition(this.getServiceName(), putOperation, partitionId);
        VersionResponsePair result2 = (VersionResponsePair)((InternalCompletableFuture)future).joinInternal();
        return (V)this.nodeEngine.toObject(result2.getResponse());
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeUnit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl must be a positive integer");
        }
        long ttlMillis = timeUnit.toMillis(ttl);
        Data dataKey = this.nodeEngine.toData(key);
        Data dataValue = this.nodeEngine.toData(value);
        int partitionId = this.partitionService.getPartitionId(dataKey);
        PutOperation putOperation = new PutOperation(this.getName(), dataKey, dataValue, ttlMillis);
        InvocationFuture future = this.getOperationService().invokeOnPartition(this.getServiceName(), putOperation, partitionId);
        VersionResponsePair result2 = (VersionResponsePair)((InternalCompletableFuture)future).joinInternal();
        return (V)this.nodeEngine.toObject(result2.getResponse());
    }

    @Override
    public V remove(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data dataKey = this.nodeEngine.toData(key);
        int partitionId = this.partitionService.getPartitionId(key);
        RemoveOperation removeOperation = new RemoveOperation(this.getName(), dataKey);
        InvocationFuture future = this.getOperationService().invokeOnPartition(this.getServiceName(), removeOperation, partitionId);
        VersionResponsePair result2 = (VersionResponsePair)((InternalCompletableFuture)future).joinInternal();
        return (V)this.nodeEngine.toObject(result2.getResponse());
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> entries) {
        Preconditions.checkNotNull(entries, "Entries cannot be null");
        int mapSize = entries.size();
        if (mapSize == 0) {
            return;
        }
        int partitionCount = this.partitionService.getPartitionCount();
        int initialSize = this.getPutAllInitialSize(mapSize, partitionCount);
        try {
            ArrayList<Future> futures = new ArrayList<Future>(partitionCount);
            MapEntries[] entrySetPerPartition = new MapEntries[partitionCount];
            for (Map.Entry<K, V> entry : entries.entrySet()) {
                Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
                Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
                int partitionId = this.partitionService.getPartitionId(entry.getKey());
                MapEntries mapEntries = entrySetPerPartition[partitionId];
                if (mapEntries == null) {
                    entrySetPerPartition[partitionId] = mapEntries = new MapEntries(initialSize);
                }
                Object keyData = this.serializationService.toData(entry.getKey());
                Object valueData = this.serializationService.toData(entry.getValue());
                mapEntries.add((Data)keyData, (Data)valueData);
            }
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                MapEntries entrySet = entrySetPerPartition[partitionId];
                if (entrySet == null) continue;
                Future future = this.createPutAllOperationFuture(this.name, entrySet, partitionId);
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private int getPutAllInitialSize(int mapSize, int partitionCount) {
        if (mapSize == 1) {
            return 1;
        }
        return (int)Math.ceil((double)(20.0f * (float)mapSize / (float)partitionCount) / Math.log10(mapSize));
    }

    private Future createPutAllOperationFuture(String name, MapEntries entrySet, int partitionId) {
        OperationService operationService = this.nodeEngine.getOperationService();
        PutAllOperation op = new PutAllOperation(name, entrySet);
        return operationService.invokeOnPartition("hz:impl:replicatedMapService", op, partitionId);
    }

    @Override
    public void clear() {
        OperationService operationService = this.nodeEngine.getOperationService();
        try {
            Map<Integer, Object> results = operationService.invokeOnAllPartitions("hz:impl:replicatedMapService", new ClearOperationFactory(this.name));
            int deletedEntrySize = 0;
            for (Object deletedEntryPerPartition : results.values()) {
                deletedEntrySize += ((Integer)deletedEntryPerPartition).intValue();
            }
            this.eventPublishingService.fireMapClearedEvent(deletedEntrySize, this.name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID id) {
        Preconditions.checkNotNull(id, "Listener ID should not be null!");
        return this.eventPublishingService.removeEventListener(this.name, id);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        return this.eventPublishingService.addLocalEventListener(listener, TrueEventFilter.INSTANCE, this.name);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nullable K key) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ReplicatedEntryEventFilter eventFilter = new ReplicatedEntryEventFilter((Data)this.serializationService.toData(key));
        return this.eventPublishingService.addLocalEventListener(listener, eventFilter, this.name);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ReplicatedQueryEventFilter eventFilter = new ReplicatedQueryEventFilter(null, predicate);
        return this.eventPublishingService.addLocalEventListener(listener, eventFilter, this.name);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull Predicate<K, V> predicate, @Nullable K key) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ReplicatedQueryEventFilter eventFilter = new ReplicatedQueryEventFilter((Data)this.serializationService.toData(key), predicate);
        return this.eventPublishingService.addLocalEventListener(listener, eventFilter, this.name);
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        Set keySet = SetUtil.createHashSet(Math.max(16, stores.size() * 4));
        for (ReplicatedRecordStore store : stores) {
            keySet.addAll(store.keySet(true));
        }
        return keySet;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        ArrayList values = new ArrayList();
        for (ReplicatedRecordStore store : stores) {
            values.addAll(store.values(true));
        }
        return values;
    }

    @Override
    @Nonnull
    public Collection<V> values(@Nullable Comparator<V> comparator) {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        ArrayList<V> values = new ArrayList<V>();
        for (ReplicatedRecordStore store : stores) {
            values.addAll(store.values(comparator));
        }
        values.sort(comparator);
        return values;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Collection<ReplicatedRecordStore> stores = this.service.getAllReplicatedRecordStores(this.getName());
        ArrayList entries = new ArrayList();
        for (ReplicatedRecordStore store : stores) {
            entries.addAll(store.entrySet(true));
        }
        return new ResultSet(entries, IterationType.ENTRY);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.name;
    }

    @Override
    @Nonnull
    public LocalReplicatedMapStats getReplicatedMapStats() {
        LocalReplicatedMapStats stats = this.config.isStatisticsEnabled() ? this.service.getLocalReplicatedMapStats(this.name) : EMPTY_LOCAL_MAP_STATS;
        return stats;
    }

    private void ensureNoSplitBrain(SplitBrainProtectionOn requiredSplitBrainProtectionPermissionType) {
        this.service.ensureNoSplitBrain(this.name, requiredSplitBrainProtectionPermissionType);
    }
}

