/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MemberHandshake
implements IdentifiedDataSerializable {
    public static final byte SCHEMA_VERSION_1 = 1;
    public static final byte SCHEMA_VERSION_2 = 2;
    public static final String OPTION_PLANE_COUNT = "planeCount";
    public static final String OPTION_PLANE_INDEX = "planeIndex";
    private byte schemaVersion;
    private Map<ProtocolType, Collection<Address>> localAddresses;
    private Address targetAddress;
    private boolean reply;
    private UUID uuid;
    private final Map<String, String> options = new HashMap<String, String>();

    public MemberHandshake() {
    }

    public MemberHandshake(byte schemaVersion, Map<ProtocolType, Collection<Address>> localAddresses, Address targetAddress, boolean reply, UUID uuid) {
        this.schemaVersion = schemaVersion;
        this.localAddresses = new EnumMap<ProtocolType, Collection<Address>>(localAddresses);
        this.targetAddress = targetAddress;
        this.reply = reply;
        this.uuid = uuid;
    }

    public MemberHandshake addOption(String key, Object value) {
        this.options.put(key, "" + value);
        return this;
    }

    public int getIntOption(String key, int defaultValue) {
        String value = this.options.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public int getPlaneCount() {
        return this.getIntOption(OPTION_PLANE_COUNT, 1);
    }

    public int getPlaneIndex() {
        return this.getIntOption(OPTION_PLANE_INDEX, 0);
    }

    byte getSchemaVersion() {
        return this.schemaVersion;
    }

    public Map<ProtocolType, Collection<Address>> getLocalAddresses() {
        return this.localAddresses;
    }

    public Address getTargetAddress() {
        return this.targetAddress;
    }

    public boolean isReply() {
        return this.reply;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.schemaVersion);
        out.writeObject(this.targetAddress);
        out.writeBoolean(this.reply);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        int size2 = this.localAddresses == null ? 0 : this.localAddresses.size();
        out.writeInt(size2);
        if (size2 > 0) {
            for (Map.Entry<ProtocolType, Collection<Address>> addressEntry : this.localAddresses.entrySet()) {
                out.writeInt(addressEntry.getKey().ordinal());
                SerializationUtil.writeCollection(addressEntry.getValue(), out);
            }
        }
        int optionsSize = this.options.size();
        out.writeInt(optionsSize);
        if (optionsSize > 0) {
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.schemaVersion = in.readByte();
        this.targetAddress = (Address)in.readObject();
        this.reply = in.readBoolean();
        this.uuid = UUIDSerializationUtil.readUUID(in);
        int size2 = in.readInt();
        if (size2 == 0) {
            this.localAddresses = Collections.emptyMap();
        } else {
            EnumMap<ProtocolType, Collection<Address>> addressesPerProtocolType = new EnumMap<ProtocolType, Collection<Address>>(ProtocolType.class);
            for (int i = 0; i < size2; ++i) {
                ProtocolType protocolType = ProtocolType.valueOf(in.readInt());
                Collection addresses = SerializationUtil.readCollection(in);
                addressesPerProtocolType.put(protocolType, addresses);
            }
            this.localAddresses = addressesPerProtocolType;
        }
        if (this.schemaVersion > 1) {
            int optionsSize = in.readInt();
            for (int k = 0; k < optionsSize; ++k) {
                this.options.put(in.readString(), in.readString());
            }
        }
    }

    public String toString() {
        return "MemberHandshake{schemaVersion=" + this.schemaVersion + ", localAddresses=" + this.localAddresses + ", targetAddress=" + this.targetAddress + ", reply=" + this.reply + ", uuid=" + this.uuid + ", options=" + this.options + '}';
    }
}

