/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.cache.impl.operation.CacheNearCacheStateHolder;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheReplicationOperation
extends Operation
implements IdentifiedDataSerializable,
Versioned {
    private final List<CacheConfig> configs = new ArrayList<CacheConfig>();
    private final Map<String, Map<Data, CacheRecord>> data = new HashMap<String, Map<Data, CacheRecord>>();
    private CacheNearCacheStateHolder nearCacheStateHolder = new CacheNearCacheStateHolder();
    private transient boolean classesAlwaysAvailable = true;

    public CacheReplicationOperation() {
        this.nearCacheStateHolder.setCacheReplicationOperation(this);
    }

    public final void prepare(CachePartitionSegment segment, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        for (ServiceNamespace namespace : namespaces) {
            CacheConfig cacheConfig;
            ObjectNamespace ns = (ObjectNamespace)namespace;
            ICacheRecordStore recordStore = segment.getRecordStore(ns.getObjectName());
            if (recordStore == null || (cacheConfig = recordStore.getConfig()).getTotalBackupCount() < replicaIndex) continue;
            this.storeRecordsToReplicate(recordStore);
        }
        this.configs.addAll(segment.getCacheConfigs());
        this.nearCacheStateHolder.prepare(segment, namespaces);
        this.classesAlwaysAvailable = segment.getCacheService().getNodeEngine().getTenantControlService().getTenantControlFactory().isClassesAlwaysAvailable();
    }

    protected void storeRecordsToReplicate(ICacheRecordStore recordStore) {
        this.data.put(recordStore.getName(), recordStore.getReadOnlyRecords());
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        for (CacheConfig config : this.configs) {
            service.putCacheConfigIfAbsent(config);
        }
    }

    @Override
    public void run() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
            ICacheRecordStore cache = service.getOrCreateRecordStore(entry.getKey(), this.getPartitionId());
            cache.reset();
            Map<Data, CacheRecord> map2 = entry.getValue();
            Iterator<Map.Entry<Data, CacheRecord>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext() && !cache.evictIfRequired()) {
                Map.Entry<Data, CacheRecord> next2 = iterator2.next();
                Data key = next2.getKey();
                CacheRecord record = next2.getValue();
                iterator2.remove();
                cache.putRecord(key, record, false);
            }
        }
        this.data.clear();
        if (this.getReplicaIndex() == 0) {
            this.nearCacheStateHolder.applyState();
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int confSize = this.configs.size();
        out.writeInt(confSize);
        for (CacheConfig config : this.configs) {
            if (!this.classesAlwaysAvailable) {
                out.writeObject(PreJoinCacheConfig.of(config));
                continue;
            }
            out.writeObject(config);
        }
        int count2 = this.data.size();
        out.writeInt(count2);
        for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
            Map<Data, CacheRecord> cacheMap = entry.getValue();
            int subCount = cacheMap.size();
            out.writeInt(subCount);
            out.writeString(entry.getKey());
            for (Map.Entry<Data, CacheRecord> e : cacheMap.entrySet()) {
                Data key = e.getKey();
                CacheRecord record = e.getValue();
                IOUtil.writeData(out, key);
                out.writeObject(record);
            }
            IOUtil.writeData(out, null);
        }
        out.writeObject(this.nearCacheStateHolder);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int confSize = in.readInt();
        for (int i = 0; i < confSize; ++i) {
            CacheConfig config = (CacheConfig)in.readObject();
            if (!this.classesAlwaysAvailable) {
                this.configs.add(PreJoinCacheConfig.asCacheConfig(config));
                continue;
            }
            this.configs.add(config);
        }
        int count2 = in.readInt();
        for (int i = 0; i < count2; ++i) {
            Data key;
            int subCount = in.readInt();
            String name = in.readString();
            Map<Data, CacheRecord> m = MapUtil.createHashMap(subCount);
            this.data.put(name, m);
            for (int j = 0; j < subCount + 1 && (key = IOUtil.readData(in)) != null && key.dataSize() != 0; ++j) {
                CacheRecord record = (CacheRecord)in.readObject();
                m.put(key, record);
            }
        }
        this.nearCacheStateHolder = (CacheNearCacheStateHolder)in.readObject();
        this.nearCacheStateHolder.setCacheReplicationOperation(this);
    }

    public boolean isEmpty() {
        return this.configs.isEmpty() && this.data.isEmpty();
    }

    Collection<CacheConfig> getConfigs() {
        return Collections.unmodifiableCollection(this.configs);
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 41;
    }

    @Override
    public boolean requiresTenantContext() {
        return true;
    }
}

