/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units.requests;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.royale.compiler.common.IDefinitionPriority;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.units.requests.FileScopeRequestResultBase;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MultipleExternallyVisibleDefinitionsProblem;
import org.apache.royale.compiler.problems.NoMainDefinitionProblem;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IScopedNode;

public class ASFileScopeRequestResult
extends FileScopeRequestResultBase {
    private final String fileName;

    public ASFileScopeRequestResult(Collection<IDefinition> definitionPromises, IDefinitionPriority definitionPriority, Collection<ICompilerProblem> problems, ASFileScope fileScope, IFileSpecification fileSpec) {
        super(problems, Collections.singleton(fileScope));
        this.fileName = fileScope.getContainingPath();
        this.addProblems(this.checkExternallyVisibleDefinitions(this.fileName, definitionPromises));
    }

    @Override
    public Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String dottedQName) {
        return this.checkExternallyVisibleDefinitions(this.fileName, dottedQName);
    }

    private Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String fileName, String expectedQName) {
        boolean foundMainDefinition = false;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.definitions.size());
        for (IDefinition def : this.definitions) {
            String defQName = def.getQualifiedName();
            if (!foundMainDefinition && expectedQName.equals(defQName)) {
                foundMainDefinition = true;
                continue;
            }
            problems.add(new MultipleExternallyVisibleDefinitionsProblem(def, def.getQualifiedName()));
        }
        if (!foundMainDefinition) {
            boolean ignoreMissingMainDefinition = false;
            for (ASFileScope scope : this.getFileScopes()) {
                for (IDefinitionSet defSet : scope.getAllLocalDefinitionSets()) {
                    int n = defSet.getSize();
                    for (int i = 0; i < n; ++i) {
                        ContainerNode packageNode;
                        IPackageDefinition packageDef;
                        ASScope packageScope;
                        IScopedNode scopeNode;
                        IDefinition def = defSet.getDefinition(i);
                        if (!(def instanceof IPackageDefinition) || (scopeNode = (packageScope = (ASScope)(packageDef = (IPackageDefinition)def).getContainedScope()).getScopeNode()) == null || !(packageNode = (ContainerNode)((Object)scopeNode)).getRemovedConditionalCompileNode()) continue;
                        ignoreMissingMainDefinition = true;
                    }
                }
            }
            if (!ignoreMissingMainDefinition) {
                problems.add(new NoMainDefinitionProblem(fileName, expectedQName));
            }
        }
        return problems;
    }

    private Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String fileName, Collection<IDefinition> definitionPromises) {
        if (definitionPromises.isEmpty()) {
            return Collections.emptyList();
        }
        assert (definitionPromises.size() == 1);
        IDefinition mainDefinitionPromise = (IDefinition)Iterables.getOnlyElement(definitionPromises);
        String mainDefinitionPromiseQName = mainDefinitionPromise.getQualifiedName();
        return this.checkExternallyVisibleDefinitions(fileName, mainDefinitionPromiseQName);
    }

    @Override
    public IDefinition getMainDefinition(String qname) {
        assert (qname != null) : "Excpect QName.";
        if (this.definitions.isEmpty()) {
            return null;
        }
        IDefinition definition = (IDefinition)this.definitions.iterator().next();
        if (qname.equals(definition.getQualifiedName())) {
            return definition;
        }
        return null;
    }
}

