/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.AppliedVectorDefinitionFactory;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLScriptNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.MXMLIncompatibleVectorElementProblem;
import org.apache.royale.compiler.problems.MXMLInvalidVectorFixedAttributeProblem;
import org.apache.royale.compiler.problems.MXMLInvalidVectorTypeAttributeProblem;
import org.apache.royale.compiler.problems.MXMLMissingVectorTypeAttributeProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLVectorNode;

class MXMLVectorNode
extends MXMLInstanceNode
implements IMXMLVectorNode {
    private static final String DOT_LESS_THAN_ESCAPED = ".&lt;";
    private static final String GREATER_THAN_ESCAPED = "&gt;";
    private ITypeDefinition type;
    private Boolean fixed = false;

    MXMLVectorNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLVectorID;
    }

    @Override
    public String getName() {
        return "Vector";
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        return projectScope.newVectorClass(this.type);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        String value = attribute.getRawValue();
        if (attribute.isSpecialAttribute("type")) {
            RoyaleProject project = builder.getProject();
            IDefinition def = this.resolveElementType(value, project);
            if (def instanceof ITypeDefinition) {
                this.type = (ITypeDefinition)def;
            } else {
                MXMLInvalidVectorTypeAttributeProblem problem = new MXMLInvalidVectorTypeAttributeProblem(attribute);
                builder.addProblem(problem);
            }
        } else if (attribute.isSpecialAttribute("fixed")) {
            value = attribute.getMXMLDialect().trim(value);
            if (value.equals("true")) {
                this.fixed = true;
            } else if (value.equals("false")) {
                this.fixed = false;
            } else {
                MXMLInvalidVectorFixedAttributeProblem problem = new MXMLInvalidVectorFixedAttributeProblem(attribute);
                builder.addProblem(problem);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private IDefinition resolveElementType(String value, RoyaleProject project) {
        int endIdx;
        IDefinition def = null;
        int dotLessIdx = value.indexOf(DOT_LESS_THAN_ESCAPED);
        if (dotLessIdx != -1 && (endIdx = value.lastIndexOf(GREATER_THAN_ESCAPED)) != -1) {
            ITypeDefinition vectorType;
            String typeArg = value.substring(dotLessIdx + 5, endIdx);
            IDefinition typeParam = this.resolveElementType(typeArg, project);
            String baseName = value.substring(0, dotLessIdx);
            IDefinition baseType = null;
            baseType = baseName.equals("Vector") ? project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR) : project.getScope().findDefinitionByName(baseName);
            if (baseType instanceof ITypeDefinition && typeParam instanceof ITypeDefinition && baseType == (vectorType = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR))) {
                def = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)typeParam);
            }
        }
        if (def == null) {
            def = project.getScope().findDefinitionByName(value);
        }
        return def;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        RoyaleProject project = builder.getProject();
        String tagName = builder.getFileScope().resolveTagToQualifiedName(childTag);
        IDefinition definition = project.getScope().findDefinitionByName(tagName);
        if (definition instanceof ClassDefinition) {
            MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, tagName, this);
            instanceNode.setClassReference(project, (ClassDefinition)definition);
            instanceNode.initializeFromTag(builder, childTag);
            info.addChildNode(instanceNode);
            if (!instanceNode.getClassReference(project).isInstanceOf(this.type, (ICompilerProject)project)) {
                MXMLIncompatibleVectorElementProblem problem = new MXMLIncompatibleVectorElementProblem(childTag);
                builder.addProblem(problem);
            }
        } else {
            MXMLUnresolvedTagProblem problem = new MXMLUnresolvedTagProblem(childTag);
            builder.addProblem(problem);
            return;
        }
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<IMXMLUnitData> contentUnits) {
        RoyaleProject project = builder.getProject();
        ITypeDefinition typeDef = defaultPropertyDefinition.resolveType(project);
        String typeName = typeDef.getQualifiedName();
        typeName = typeName.replace(".<", DOT_LESS_THAN_ESCAPED);
        typeName = typeName.replace(">", GREATER_THAN_ESCAPED);
        this.type = (ITypeDefinition)this.resolveElementType(typeName, project);
        this.setLocation(builder, contentUnits);
        this.setClassReference(project, "Vector");
        ArrayList<MXMLNodeBase> children = new ArrayList<MXMLNodeBase>();
        for (IMXMLUnitData unit : contentUnits) {
            if (!(unit instanceof IMXMLTagData)) continue;
            IMXMLTagData tag = (IMXMLTagData)unit;
            if (builder.getFileScope().isScriptTag(tag)) {
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, tag);
                children.add(scriptNode);
                continue;
            }
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (!(definition instanceof IClassDefinition)) continue;
            MXMLInstanceNode childNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
            childNode.setClassReference(project, (ClassDefinition)definition);
            childNode.initializeFromTag(builder, tag);
            children.add(childNode);
        }
        this.setChildren(children.toArray(new IMXMLNode[0]));
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.setChildren(info.getChildNodeList().toArray(new MXMLInstanceNode[0]));
        if (this.type != null) {
            RoyaleProject project = builder.getProject();
            ITypeDefinition t = this.type;
            while (t instanceof AppliedVectorDefinition) {
                t = ((AppliedVectorDefinition)t).resolveElementType(project);
            }
            String qname = t.getQualifiedName();
            builder.addDependency(qname, DependencyType.EXPRESSION);
            if (this.getID() != null) {
                builder.addDependency(qname, DependencyType.SIGNATURE);
            }
        } else {
            MXMLMissingVectorTypeAttributeProblem problem = new MXMLMissingVectorTypeAttributeProblem(tag);
            builder.addProblem(problem);
        }
    }

    @Override
    public ITypeDefinition getType() {
        return this.type;
    }

    @Override
    public boolean getFixed() {
        return this.fixed;
    }
}

