/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.CDATANode;
import org.apache.royale.compiler.internal.fxg.dom.ITextNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.AbstractRichTextNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.BRNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.ImgNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.SpanNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TCYNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TabNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TextLayoutFormatNode;
import org.apache.royale.compiler.problems.FXGInvalidNestingElementsProblem;
import org.apache.royale.compiler.problems.FXGMultipleElementProblem;
import org.apache.royale.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class LinkNode
extends AbstractRichTextLeafNode {
    public String href;
    public String target = "";
    public TextLayoutFormatNode linkNormalFormat = null;
    public TextLayoutFormatNode linkHoverFormat = null;
    public TextLayoutFormatNode linkActiveFormat = null;
    protected HashMap<String, ITextNode> properties;

    public HashMap<String, ITextNode> getTextProperties() {
        return this.properties;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        if (node instanceof TextLayoutFormatNode) {
            if ("linkActiveFormat".equals(propertyName)) {
                if (this.linkActiveFormat == null) {
                    this.linkActiveFormat = (TextLayoutFormatNode)node;
                    this.linkActiveFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkActiveFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkHoverFormat".equals(propertyName)) {
                if (this.linkHoverFormat == null) {
                    this.linkHoverFormat = (TextLayoutFormatNode)node;
                    this.linkHoverFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkHoverFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkNormalFormat".equals(propertyName)) {
                if (this.linkNormalFormat == null) {
                    this.linkNormalFormat = (TextLayoutFormatNode)node;
                    this.linkNormalFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkNormalFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else {
                problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), node.getStartLine(), node.getStartColumn(), node.getNodeName(), propertyName));
            }
        } else {
            super.addTextProperty(propertyName, node, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "a";
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof ImgNode || child instanceof TCYNode || child instanceof CDATANode) {
            if (child instanceof TCYNode && this.parentNode instanceof TCYNode) {
                problems.add(new FXGInvalidNestingElementsProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
                return;
            }
            if (this.content == null) {
                this.content = new ArrayList();
            }
        } else {
            super.addChild(child, problems);
            return;
        }
        this.content.add((ITextNode)child);
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("href".equals(name)) {
            this.href = value;
        } else if ("target".equals(name)) {
            this.target = value;
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }
}

