/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.MXMLTokenQuery;
import org.apache.royale.linter.MXMLTokenVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.TokenVisitor;
import org.apache.royale.linter.problems.ILinterProblem;

public class EmptyCommentRule
extends LinterRule {
    @Override
    public Map<Integer, TokenVisitor> getTokenVisitors() {
        HashMap<Integer, TokenVisitor> result = new HashMap<Integer, TokenVisitor>();
        result.put(5, (token, tokenQuery, problems) -> this.checkSingleLineComment(token, tokenQuery, problems));
        result.put(8, (token, tokenQuery, problems) -> this.checkMultiLineComment(token, tokenQuery, problems));
        return result;
    }

    @Override
    public Map<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor> getMXMLTokenVisitors() {
        HashMap<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor> result = new HashMap<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor>();
        result.put(IMXMLToken.MXMLTokenKind.COMMENT, (token, tokenQuery, problems) -> this.checkMXMLComment(token, tokenQuery, problems));
        return result;
    }

    private void checkSingleLineComment(IASToken comment, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        String commentText = comment.getText();
        if ((commentText = commentText.substring(2).trim()).length() > 0) {
            return;
        }
        problems.add(new EmptyCommentLinterProblem(comment));
    }

    private void checkMultiLineComment(IASToken comment, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        String commentText = comment.getText();
        if ((commentText = commentText.substring(2, commentText.length() - 2).trim()).length() > 0) {
            return;
        }
        problems.add(new EmptyCommentLinterProblem(comment));
    }

    private void checkMXMLComment(IMXMLToken comment, MXMLTokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        boolean isASDoc;
        String commentText = comment.getText();
        boolean bl = isASDoc = commentText.startsWith("<!---") && commentText.length() > 7;
        if (isASDoc) {
            return;
        }
        if ((commentText = commentText.substring(4, commentText.length() - 3).trim()).length() > 0) {
            return;
        }
        problems.add(new EmptyCommentLinterProblem(comment));
    }

    public static class EmptyCommentLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Comment must not be empty";

        public EmptyCommentLinterProblem(IASToken token) {
            super(token);
        }

        public EmptyCommentLinterProblem(IMXMLToken token) {
            super((ISourceLocation)token);
        }
    }
}

