/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.asdoc.IASDocBundleDelegate;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.css.ICSSManager;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IEffectDefinition;
import org.apache.royale.compiler.definitions.IEventDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.exceptions.LibraryCircularDependencyException;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.royale.compiler.internal.css.CSSManager;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.PackageDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLManifestManager;
import org.apache.royale.compiler.internal.mxml.MXMLNamespaceMapping;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.internal.projects.LibraryDependencyGraph;
import org.apache.royale.compiler.internal.projects.MXMLSourceFileHandler;
import org.apache.royale.compiler.internal.projects.ResourceBundleSourceFileHandler;
import org.apache.royale.compiler.internal.projects.ThemeUtilities;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.targets.AppSWFTarget;
import org.apache.royale.compiler.internal.targets.RoyaleAppSWFTarget;
import org.apache.royale.compiler.internal.targets.SWCTarget;
import org.apache.royale.compiler.internal.tree.mxml.MXMLImplicitImportNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLManifestManager;
import org.apache.royale.compiler.mxml.IMXMLNamespaceMapping;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.projects.ICompilerProjectWithNamedColor;
import org.apache.royale.compiler.projects.IRoyaleProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.targets.ISWCTarget;
import org.apache.royale.compiler.targets.ISWFTarget;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.swc.ISWC;

public class RoyaleProject
extends ASProject
implements IRoyaleProject,
ICompilerProjectWithNamedColor {
    private final ICSSManager cssManager;
    private Collection<String> locales;
    private final Map<String, String> localeDependentPaths;
    private String componentTagType;
    private String stateClass;
    public ITypeDefinition stateClassType = null;
    private String stateClientInterface;
    private String instanceOverrideClass;
    private Name instanceOverrideClassName;
    private String propertyOverrideClass;
    private Name propertyOverrideClassName;
    private String styleOverrideClass;
    private Name styleOverrideClassName;
    private String eventOverrideClass;
    private Name eventOverrideClassName;
    private String deferredInstanceInterface;
    private String transientDeferredInstanceInterface;
    private String deferredInstanceFromClassClass;
    private String deferredInstanceFromFunctionClass;
    private Name deferredInstanceFromFunctionName;
    private String factoryInterface;
    private String proxyBaseClass;
    private String classFactoryClass;
    private String mxmlObjectInterface;
    private Boolean mxmlForceLocalId;
    private String containerInterface;
    private String visualElementContainerInterface;
    private String resourceBundleClass;
    private String resourceManagerClass;
    private String resourceModuleBaseClass;
    private Name resourceManagerClassName;
    private String bindingManagerClass;
    private Name bindingManagerClassName;
    private String bindingClass;
    private Name bindingClassName;
    private List<RSLSettings> rslSettingsList;
    private ImmutableList<IFileSpecification> themeFiles = ImmutableList.of();
    private String propertyWatcherClass;
    private String staticPropertyWatcherClass;
    private Name propertyWatcherClassName;
    private Name staticPropertyWatcherClassName;
    private String functionReturnWatcherClass;
    private Name functionReturnWatcherClassName;
    private String objectProxyClass;
    private String xmlWatcherClass;
    private Name xmlWatcherClassName;
    private String swfDebugfileAlias;
    private String uiComponentDescriptorClass;
    private Name uiComponentDescriptorClassName;
    private String modelClass;
    private Name modelClassName;
    private String cssStyleDeclarationClass;
    private Name cssStyleDeclarationClassName;
    private String royaleModuleInterface;
    private String deferredInstantiationUIComponentInterface;
    private Map<String, Integer> namedColors;
    private String[] implicitImportsForMXML;
    private List<IImportNode> implicitImportNodesForMXML;
    private IMXMLNamespaceMapping[] namespaceMappings;
    private IMXMLManifestManager manifestManager;
    private String xmlUtilClass;
    private Name xmlUtilClassName;
    private String servicesXMLPath;
    private String servicesContextRoot;
    private String webServiceQName;
    private String webServiceOperationQName;
    private String remoteObjectQName;
    private String remoteObjectMethodQName;
    private String actionScriptFileEncoding = "utf-8";
    private Map<File, List<String>> extensions;
    private boolean isRoyale = false;
    private boolean strictXML = false;
    private String httpServiceQName;
    private String designLayerQName;
    private String repeaterQName;
    private ITargetSettings targetSettings;
    private ISWFTarget target;
    private boolean isTranspiling;
    private boolean allowPrivateNameConflicts;
    private boolean allowImportAliases = false;
    private boolean allowAbstractClasses = false;
    private boolean allowPrivateConstructors = false;
    private boolean strictIdentifierNames = false;
    public File apiReportFile;
    HashMap<String, Integer> apiMap = new HashMap();
    private HashMap<IClassDefinition, BindingDatabase> bindingMap = new HashMap();

    public RoyaleProject(Workspace workspace, IASDocBundleDelegate asDocBundleDelegate) {
        super(workspace, true, asDocBundleDelegate);
        this.getSourceCompilationUnitFactory().addHandler(MXMLSourceFileHandler.INSTANCE);
        this.getSourceCompilationUnitFactory().addHandler(ResourceBundleSourceFileHandler.INSTANCE);
        this.namespaceMappings = new MXMLNamespaceMapping[0];
        this.implicitImportsForMXML = new String[0];
        this.implicitImportNodesForMXML = new ArrayList<IImportNode>();
        this.cssManager = new CSSManager(this);
        this.localeDependentPaths = new HashMap<String, String>();
        this.locales = Collections.unmodifiableCollection(Collections.emptySet());
    }

    public RoyaleProject(Workspace workspace) {
        this(workspace, IASDocBundleDelegate.NIL_DELEGATE);
    }

    public ITargetSettings getTargetSettings() {
        return this.targetSettings;
    }

    public void setTargetSettings(ITargetSettings value) {
        this.targetSettings = value;
    }

    public ISWFTarget getSWFTarget() {
        return this.target;
    }

    @Override
    public ISWFTarget createSWFTarget(ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        this.targetSettings = targetSettings;
        if (this.isRoyale()) {
            String rootClassName = targetSettings.getRootClassName();
            this.target = new RoyaleAppSWFTarget(ReferenceFactory.packageQualifiedReference(this.getWorkspace(), rootClassName, true), this, targetSettings, progressMonitor);
        } else {
            this.target = new AppSWFTarget(this, targetSettings, progressMonitor);
        }
        return this.target;
    }

    @Override
    public ISWCTarget createSWCTarget(ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        this.targetSettings = targetSettings;
        return new SWCTarget(this, targetSettings, progressMonitor);
    }

    public int getColorAsInt(String colorValue) throws NumberFormatException {
        Integer value;
        if (colorValue == null) {
            throw new NullPointerException("colorValue may not be null");
        }
        if (this.namedColors != null && (value = this.namedColors.get(colorValue)) != null) {
            return value;
        }
        return Integer.decode(colorValue);
    }

    public String getComponentTagType() {
        return this.componentTagType;
    }

    public void setComponentTagType(String componentTagType) {
        this.componentTagType = componentTagType;
    }

    public String getStateClass() {
        return this.stateClass;
    }

    public void setStateClass(String stateClass) {
        this.stateClass = stateClass;
    }

    public String getStateClientInterface() {
        return this.stateClientInterface;
    }

    public void setStateClientInterface(String stateClientInterface) {
        this.stateClientInterface = stateClientInterface;
    }

    public String getInstanceOverrideClass() {
        return this.instanceOverrideClass;
    }

    public Name getInstanceOverrideClassName() {
        return this.instanceOverrideClassName;
    }

    public void setInstanceOverrideClass(String instanceOverrideClass) {
        this.instanceOverrideClass = instanceOverrideClass;
        this.instanceOverrideClassName = this.getMNameForQName(instanceOverrideClass);
    }

    public String getPropertyOverrideClass() {
        return this.propertyOverrideClass;
    }

    public Name getPropertyOverrideClassName() {
        return this.propertyOverrideClassName;
    }

    public void setPropertyOverrideClass(String propertyOverrideClass) {
        this.propertyOverrideClass = propertyOverrideClass;
        this.propertyOverrideClassName = this.getMNameForQName(propertyOverrideClass);
    }

    public String getStyleOverrideClass() {
        return this.styleOverrideClass;
    }

    public Name getStyleOverrideClassName() {
        return this.styleOverrideClassName;
    }

    public void setStyleOverrideClass(String styleOverrideClass) {
        this.styleOverrideClass = styleOverrideClass;
        this.styleOverrideClassName = this.getMNameForQName(styleOverrideClass);
    }

    public String getEventOverrideClass() {
        return this.eventOverrideClass;
    }

    public Name getEventOverrideClassName() {
        return this.eventOverrideClassName;
    }

    public void setEventOverrideClass(String eventOverrideClass) {
        this.eventOverrideClass = eventOverrideClass;
        this.eventOverrideClassName = this.getMNameForQName(eventOverrideClass);
    }

    public String getDeferredInstanceInterface() {
        return this.deferredInstanceInterface;
    }

    public void setDeferredInstanceInterface(String deferredInstanceInterface) {
        this.deferredInstanceInterface = deferredInstanceInterface;
    }

    public String getTransientDeferredInstanceInterface() {
        return this.transientDeferredInstanceInterface;
    }

    public void setTransientDeferredInstanceInterface(String transientDeferredInstanceInterface) {
        this.transientDeferredInstanceInterface = transientDeferredInstanceInterface;
    }

    public String getDeferredInstanceFromClassClass() {
        return this.deferredInstanceFromClassClass;
    }

    public void setDeferredInstanceFromClassClass(String deferredInstanceFromClassClass) {
        this.deferredInstanceFromClassClass = deferredInstanceFromClassClass;
    }

    public String getDeferredInstanceFromFunctionClass() {
        return this.deferredInstanceFromFunctionClass;
    }

    public Name getDeferredInstanceFromFunctionName() {
        return this.deferredInstanceFromFunctionName;
    }

    public void setDeferredInstanceFromFunctionClass(String deferredInstanceFromFunctionClass) {
        this.deferredInstanceFromFunctionClass = deferredInstanceFromFunctionClass;
        this.deferredInstanceFromFunctionName = this.getMNameForQName(deferredInstanceFromFunctionClass);
    }

    public String getFactoryInterface() {
        return this.factoryInterface;
    }

    public void setFactoryInterface(String factoryInterface) {
        this.factoryInterface = factoryInterface;
    }

    public String getMXMLObjectInterface() {
        return this.mxmlObjectInterface;
    }

    public void setMXMLObjectInterface(String mxmlObjectInterface) {
        this.mxmlObjectInterface = mxmlObjectInterface;
    }

    public Boolean getMXMLForceLocalId() {
        return this.mxmlForceLocalId;
    }

    public void setMXMLForceLocalId(Boolean mxmlForceLocalId) {
        this.mxmlForceLocalId = mxmlForceLocalId;
    }

    public String getProxyBaseClass() {
        return this.proxyBaseClass;
    }

    public void setProxyBaseClass(String proxyBaseClass) {
        this.proxyBaseClass = proxyBaseClass;
    }

    public String getClassFactoryClass() {
        return this.classFactoryClass;
    }

    public void setClassFactoryClass(String classFactoryClass) {
        this.classFactoryClass = classFactoryClass;
    }

    public String getContainerInterface() {
        return this.containerInterface;
    }

    public void setContainerInterface(String containerInterface) {
        this.containerInterface = containerInterface;
    }

    public String getVisualElementContainerInterface() {
        return this.visualElementContainerInterface;
    }

    public void setVisualElementContainerInterface(String visualElementContainerInterface) {
        this.visualElementContainerInterface = visualElementContainerInterface;
    }

    public String getResourceBundleClass() {
        return this.resourceBundleClass;
    }

    public void setResourceBundleClass(String resourceBundleClass) {
        this.resourceBundleClass = resourceBundleClass;
    }

    public String getResourceManagerClass() {
        return this.resourceManagerClass;
    }

    public Name getResourceManagerClassName() {
        return this.resourceManagerClassName;
    }

    public void setResourceManagerClass(String resourceManagerClass) {
        this.resourceManagerClass = resourceManagerClass;
        this.resourceManagerClassName = this.getMNameForQName(resourceManagerClass);
    }

    public String getBindingManagerClass() {
        return this.bindingManagerClass;
    }

    public Name getBindingManagerClassName() {
        return this.bindingManagerClassName;
    }

    public String getResourceModuleBaseClass() {
        return this.resourceModuleBaseClass;
    }

    public void setResourceModuleBaseClass(String resourceModuleBaseClass) {
        this.resourceModuleBaseClass = resourceModuleBaseClass;
    }

    public void setBindingManagerClass(String bindingManagerClass) {
        this.bindingManagerClass = bindingManagerClass;
        this.bindingManagerClassName = this.getMNameForQName(bindingManagerClass);
    }

    public String getXMLUtilClass() {
        return this.xmlUtilClass;
    }

    public Name getXMLUtilClassName() {
        return this.xmlUtilClassName;
    }

    public void setXMLUtilClass(String xmlUtilClass) {
        this.xmlUtilClass = xmlUtilClass;
        this.xmlUtilClassName = this.getMNameForQName(xmlUtilClass);
    }

    public String getBindingClass() {
        return this.bindingClass;
    }

    public Name getBindingClassName() {
        assert (this.bindingClassName != null);
        return this.bindingClassName;
    }

    public void setBindingClass(String bindingClass) {
        this.bindingClass = bindingClass;
        this.bindingClassName = this.getMNameForQName(bindingClass);
    }

    public String getPropertyWatcherClass() {
        return this.propertyWatcherClass;
    }

    public String getObjectProxyClass() {
        return this.objectProxyClass;
    }

    public void setObjectProxyClass(String objectProxyClass) {
        this.objectProxyClass = objectProxyClass;
    }

    public Name getPropertyWatcherClassName() {
        assert (this.propertyWatcherClassName != null);
        return this.propertyWatcherClassName;
    }

    public void setPropertyWatcherClass(String propertyWatcherClass) {
        this.propertyWatcherClass = propertyWatcherClass;
        this.propertyWatcherClassName = this.getMNameForQName(propertyWatcherClass);
    }

    public String getStaticPropertyWatcherClass() {
        return this.staticPropertyWatcherClass;
    }

    public Name getStaticPropertyWatcherClassName() {
        assert (this.staticPropertyWatcherClassName != null);
        return this.staticPropertyWatcherClassName;
    }

    public void setStaticPropertyWatcherClass(String staticPropertyWatcherClass) {
        this.staticPropertyWatcherClass = staticPropertyWatcherClass;
        this.staticPropertyWatcherClassName = this.getMNameForQName(staticPropertyWatcherClass);
    }

    public Name getXMLWatcherClassName() {
        return this.xmlWatcherClassName;
    }

    public String getXMLWatcherClass() {
        return this.xmlWatcherClass;
    }

    public void setXMLWatcherClass(String xmlWatcherClass) {
        this.xmlWatcherClass = xmlWatcherClass;
        this.xmlWatcherClassName = this.getMNameForQName(xmlWatcherClass);
    }

    public String getFunctionReturnWatcherClass() {
        return this.functionReturnWatcherClass;
    }

    public Name getFunctionReturnWatcherClassName() {
        assert (this.functionReturnWatcherClassName != null);
        return this.functionReturnWatcherClassName;
    }

    public void setFunctionReturnWatcherClass(String staticPropertyWatcherClass) {
        this.functionReturnWatcherClass = staticPropertyWatcherClass;
        this.functionReturnWatcherClassName = this.getMNameForQName(staticPropertyWatcherClass);
    }

    public String getUIComponentDescriptorClass() {
        return this.uiComponentDescriptorClass;
    }

    public Name getUIComponentDescriptorClassName() {
        return this.uiComponentDescriptorClassName;
    }

    public void setUIComponentDescriptorClass(String uiComponentDescriptorClass) {
        this.uiComponentDescriptorClass = uiComponentDescriptorClass;
        this.uiComponentDescriptorClassName = this.getMNameForQName(uiComponentDescriptorClass);
    }

    public String getModelClass() {
        return this.modelClass;
    }

    public Name getModelClassName() {
        return this.modelClassName;
    }

    public void setModelClass(String modelClass) {
        this.modelClass = modelClass;
        this.modelClassName = this.getMNameForQName(modelClass);
    }

    public String getCSSStyleDeclarationClass() {
        return this.cssStyleDeclarationClass;
    }

    public Name getCSSStyleDeclarationClassName() {
        return this.cssStyleDeclarationClassName;
    }

    public void setCSSStyleDeclarationClass(String cssStyleDeclarationClass) {
        this.cssStyleDeclarationClass = cssStyleDeclarationClass;
        this.cssStyleDeclarationClassName = this.getMNameForQName(cssStyleDeclarationClass);
    }

    public String getFlexModuleInterface() {
        return this.royaleModuleInterface;
    }

    public void setFlexModuleInterface(String royaleModuleInterface) {
        this.royaleModuleInterface = royaleModuleInterface;
    }

    public String getDeferredInstantiationUIComponentInterface() {
        return this.deferredInstantiationUIComponentInterface;
    }

    public void setDeferredInstantiationUIComponentInterface(String deferredInstantiationUIComponentInterface) {
        this.deferredInstantiationUIComponentInterface = deferredInstantiationUIComponentInterface;
    }

    @Override
    public Integer getNamedColor(String colorName) {
        return this.namedColors != null ? this.namedColors.get(colorName) : null;
    }

    public void setNamedColors(Map<String, Integer> namedColors) {
        this.namedColors = namedColors;
    }

    private List<String> getMXMLVersionDependentImports(MXMLDialect dialect) {
        ArrayList<String> imports = new ArrayList<String>();
        if (dialect.isEqualToOrAfter(MXMLDialect.MXML_2009)) {
            imports.add("mx.filters.*");
            imports.add("spark.filters.*");
        } else {
            imports.add("flash.filters.*");
        }
        return imports;
    }

    public String[] getImplicitImportsForMXML(MXMLDialect dialect) {
        String[] additionalImports = this.getMXMLVersionDependentImports(dialect).toArray(new String[0]);
        String[] imports = new String[this.implicitImportsForMXML.length + additionalImports.length];
        System.arraycopy(this.implicitImportsForMXML, 0, imports, 0, this.implicitImportsForMXML.length);
        System.arraycopy(additionalImports, 0, imports, this.implicitImportsForMXML.length, additionalImports.length);
        return imports;
    }

    public List<IImportNode> getImplicitImportNodesForMXML(MXMLDialect dialect) {
        List<String> additionalImports = this.getMXMLVersionDependentImports(dialect);
        ArrayList<IImportNode> importNodes = new ArrayList<IImportNode>(this.implicitImportNodesForMXML.size() + additionalImports.size());
        importNodes.addAll(this.implicitImportNodesForMXML);
        for (String additionalImport : additionalImports) {
            importNodes.add(new MXMLImplicitImportNode(this, additionalImport));
        }
        return importNodes;
    }

    public void setImplicitImportsForMXML(String[] implicitImportsForMXML) {
        this.implicitImportsForMXML = implicitImportsForMXML;
        this.implicitImportNodesForMXML = new ArrayList<IImportNode>(implicitImportsForMXML.length);
        for (String implicitImport : implicitImportsForMXML) {
            this.implicitImportNodesForMXML.add(new MXMLImplicitImportNode(this, implicitImport));
        }
    }

    @Override
    public IMXMLNamespaceMapping[] getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public void invalidateManifestManager() {
        this.manifestManager = null;
    }

    private IMXMLManifestManager getMXMLManifestManager() {
        if (this.manifestManager == null) {
            this.manifestManager = new MXMLManifestManager(this);
        }
        return this.manifestManager;
    }

    @Override
    public String resolveXMLNameToQualifiedName(XMLName xmlName, MXMLDialect mxmlDialect) {
        XMLName componentTag;
        String qname = this.getMXMLManifestManager().resolve(xmlName);
        if (qname == null) {
            String shortName = xmlName.getName();
            String uri = xmlName.getXMLNamespace();
            String packageName = PackageDefinition.getQualifiedPackageNameFromNamespaceURI(uri);
            if (packageName != null) {
                String string = qname = packageName.length() == 0 ? shortName : packageName + "." + shortName;
            }
        }
        if (qname == null && xmlName.getName().equals("State") && (mxmlDialect.isEqualToOrAfter(MXMLDialect.MXML_2009) && xmlName.getXMLNamespace().equals("library://ns.adobe.com/flex/spark") || mxmlDialect == MXMLDialect.MXML_2006 && xmlName.getXMLNamespace().equals("http://www.adobe.com/2006/mxml"))) {
            qname = this.stateClass;
        }
        if (qname == null && xmlName.equals(componentTag = mxmlDialect.resolveComponent())) {
            qname = this.componentTagType;
        }
        return qname;
    }

    @Override
    public IDefinition resolveXMLNameToDefinition(XMLName xmlName, MXMLDialect mxmlDialect) {
        String qName = this.resolveXMLNameToQualifiedName(xmlName, mxmlDialect);
        if (qName != null) {
            return this.resolveQNameToDefinition(qName);
        }
        return null;
    }

    public IDefinition resolveSpecifier(IClassDefinition classDefinition, String specifierName) {
        IDefinition definition = null;
        definition = this.resolveEvent(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveProperty(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveEffect(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveStyle(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        return null;
    }

    public IDefinition resolveProperty(IClassDefinition classDefinition, String propertyName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            ASScope classScope = ((ClassDefinition)c).getContainedScope();
            IDefinitionSet definitionSet = classScope.getLocalDefinitionSetByName(propertyName);
            if (definitionSet == null) continue;
            IDefinition winner = null;
            int n = definitionSet.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition definition = definitionSet.getDefinition(i);
                if (!(definition instanceof IVariableDefinition) || definition instanceof IGetterDefinition) continue;
                winner = definition;
                INamespaceReference namespaceReference = definition.getNamespaceReference();
                INamespaceDefinition thisNamespaceDef = namespaceReference.resolveNamespaceReference(this);
                boolean isBindable = ((NamespaceDefinition)thisNamespaceDef).getAETNamespace().getName().equals(BindableHelper.bindableNamespaceDefinition.getAETNamespace().getName());
                if (winner instanceof ISetterDefinition && !isBindable) break;
            }
            if (winner == null) continue;
            if (this.apiReportFile != null) {
                this.addToAPIReport(classDefinition, winner);
            }
            return winner;
        }
        return null;
    }

    public IEventDefinition resolveEvent(IClassDefinition classDefinition, String eventName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IEventDefinition eventDefinition = c.getEventDefinition(this.getWorkspace(), eventName);
            if (eventDefinition == null) continue;
            if (this.apiReportFile != null) {
                this.addToAPIReport(classDefinition, eventDefinition);
            }
            return eventDefinition;
        }
        return null;
    }

    public IStyleDefinition resolveStyle(IClassDefinition classDefinition, String styleName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        Workspace w = this.getWorkspace();
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IStyleDefinition styleDefinition = c.getStyleDefinition(w, styleName);
            if (styleDefinition == null) continue;
            if (this.apiReportFile != null) {
                this.addToAPIReport(classDefinition, styleDefinition);
            }
            return styleDefinition;
        }
        return null;
    }

    public IEffectDefinition resolveEffect(IClassDefinition classDefinition, String effectName) {
        Workspace w = this.getWorkspace();
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IEffectDefinition effectDefinition = c.getEffectDefinition(w, effectName);
            if (effectDefinition == null) continue;
            return effectDefinition;
        }
        return null;
    }

    @Override
    public Collection<XMLName> getTagNamesForClass(String className) {
        return this.getMXMLManifestManager().getTagNamesForClass(className);
    }

    public Collection<String> getQualifiedClassNamesForManifestNamespaces(Set<String> namespaceURIs) {
        return this.getMXMLManifestManager().getQualifiedNamesForNamespaces(namespaceURIs, true);
    }

    public boolean isManifestComponentLookupOnly(XMLName tagName) {
        return this.getMXMLManifestManager().isLookupOnly(tagName);
    }

    @Override
    public ICSSManager getCSSManager() {
        return this.cssManager;
    }

    public CSSCompilationSession getCSSCompilationSession() {
        return new CSSCompilationSession();
    }

    public String getServciesContextRoot() {
        return this.servicesContextRoot;
    }

    @Override
    public String getServicesXMLPath() {
        return this.servicesXMLPath;
    }

    @Override
    public void setServicesXMLPath(String path, String contextRoot) {
        this.servicesXMLPath = path;
        this.servicesContextRoot = contextRoot;
    }

    @Override
    public Collection<String> getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(Collection<String> locales) {
        assert (locales != null) : "Locales cannot be set to null";
        this.locales = Collections.unmodifiableCollection(locales);
        this.clean();
    }

    @Override
    public String getResourceLocale(String path) {
        return this.localeDependentPaths.get(path);
    }

    @Override
    public void setLocaleDependentResources(Map<String, String> localeDependentResources) {
        this.localeDependentPaths.clear();
        this.localeDependentPaths.putAll(localeDependentResources);
        this.clean();
    }

    private Name getMNameForQName(String qname) {
        Workspace workspace = this.getWorkspace();
        IResolvedQualifiersReference reference = ReferenceFactory.packageQualifiedReference(workspace, qname);
        return reference.getMName();
    }

    public void setWebServiceClass(String name) {
        this.webServiceQName = name;
    }

    public String getWebServiceQName() {
        return this.webServiceQName;
    }

    public void setWebServiceOperationClass(String name) {
        this.webServiceOperationQName = name;
    }

    public String getWebServiceOperationQName() {
        return this.webServiceOperationQName;
    }

    public void setRemoteObjectMethodClass(String name) {
        this.remoteObjectMethodQName = name;
    }

    public String getRemoteObjectMethodQName() {
        return this.remoteObjectMethodQName;
    }

    public void setRemoteObjectClass(String name) {
        this.remoteObjectQName = name;
    }

    public String getRemoteObjectQName() {
        return this.remoteObjectQName;
    }

    public void setHTTPServiceClass(String name) {
        this.httpServiceQName = name;
    }

    public String getHTTPServiceQName() {
        return this.httpServiceQName;
    }

    public void setDesignLayerClass(String name) {
        this.designLayerQName = name;
    }

    public String getDesignLayerQName() {
        return this.designLayerQName;
    }

    public void setRepeaterClass(String name) {
        this.repeaterQName = name;
    }

    public String getRepeaterQName() {
        return this.repeaterQName;
    }

    @Override
    public void setIncludeSources(Collection<File> sources) throws InterruptedException {
        Set<File> files = this.populateIncludedSourceFiles(sources);
        super.setIncludeSources(files.toArray(new File[files.size()]));
    }

    @Override
    public void setActionScriptFileEncoding(String encoding) {
        this.actionScriptFileEncoding = encoding;
        this.clean();
    }

    @Override
    public String getActionScriptFileEncoding() {
        return this.actionScriptFileEncoding;
    }

    @Override
    public void setDefineDirectives(Map<String, String> defines) {
        this.overrideDefines(defines);
        this.addConfigVariables(defines);
        if (defines.containsKey("COMPILE::SWF")) {
            this.isTranspiling = defines.get("COMPILE::SWF").equalsIgnoreCase("false");
        }
        this.clean();
    }

    protected void overrideDefines(Map<String, String> defines) {
        if (defines.containsKey("COMPILE::SWF") && defines.get("COMPILE::SWF").equals("AUTO")) {
            defines.put("COMPILE::SWF", "true");
        }
        if (defines.containsKey("COMPILE::JS") && defines.get("COMPILE::JS").equals("AUTO")) {
            defines.put("COMPILE::JS", "false");
        }
    }

    @Override
    public void setExtensionLibraries(Map<File, List<String>> extensions) {
        this.extensions = extensions;
        this.clean();
    }

    @Override
    public Map<File, List<String>> getExtensionLibraries() {
        return this.extensions != null ? this.extensions : Collections.emptyMap();
    }

    private static boolean namespaceMappingsDiffer(IMXMLNamespaceMapping[] oldMappings, List<? extends IMXMLNamespaceMapping> newMappings) {
        if (oldMappings.length != newMappings.size()) {
            return true;
        }
        int nMappings = oldMappings.length;
        for (int i = 0; i < nMappings; ++i) {
            IMXMLNamespaceMapping oldMapping = oldMappings[i];
            IMXMLNamespaceMapping newMapping = newMappings.get(i);
            if (!oldMapping.getManifestFileName().equals(newMapping.getManifestFileName())) {
                return true;
            }
            if (oldMapping.getURI().equals(newMapping.getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setNamespaceMappings(List<? extends IMXMLNamespaceMapping> namespaceMappings) {
        if (RoyaleProject.namespaceMappingsDiffer(this.namespaceMappings, namespaceMappings)) {
            this.namespaceMappings = namespaceMappings.toArray(new MXMLNamespaceMapping[namespaceMappings.size()]);
            this.clean();
        }
    }

    @Override
    public List<RSLSettings> getRuntimeSharedLibraryPath() {
        return this.rslSettingsList != null ? this.rslSettingsList : Collections.emptyList();
    }

    @Override
    public void setRuntimeSharedLibraryPath(List<RSLSettings> rslSettings) {
        this.rslSettingsList = rslSettings;
        this.clean();
    }

    public void setThemeFiles(List<IFileSpecification> files) {
        this.themeFiles = files != null ? ImmutableList.copyOf(files) : ImmutableList.of();
        this.clean();
    }

    public List<IFileSpecification> getThemeFiles() {
        return this.themeFiles;
    }

    @Override
    public Set<String> computeLibraryDependencies(File targetLibrary, DependencyTypeSet dependencySet) throws LibraryCircularDependencyException {
        assert (targetLibrary != null) : "targetLibrary may not be null";
        LibraryDependencyGraph libraryGraph = this.createLibraryDependencyGraph(dependencySet);
        return libraryGraph.getDependencies(targetLibrary.getAbsolutePath());
    }

    @Override
    public List<String> computeLibraryDependencyOrder(DependencyTypeSet dependencySet) throws LibraryCircularDependencyException {
        LibraryDependencyGraph libraryGraph = this.createLibraryDependencyGraph(dependencySet);
        return libraryGraph.getDependencyOrder();
    }

    public LibraryDependencyGraph createLibraryDependencyGraph(DependencyTypeSet dependencySet) {
        List<ISWC> swcs = this.getLibraries();
        Workspace w = this.getWorkspace();
        ArrayList<IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit>> requests = new ArrayList<IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit>>();
        HashSet<ICompilationUnit> swcUnits = new HashSet<ICompilationUnit>();
        for (ISWC iSWC : swcs) {
            String path = iSWC.getSWCFile().getAbsolutePath();
            Collection<ICompilationUnit> units = w.getCompilationUnits(path, this);
            swcUnits.addAll(units);
            for (ICompilationUnit unit : units) {
                requests.add(unit.getOutgoingDependenciesRequest());
            }
        }
        for (IRequest iRequest : requests) {
            try {
                iRequest.get();
            }
            catch (InterruptedException e) {
                assert (false) : "Unexpected interruption";
                return null;
            }
        }
        DependencyGraph unitGraph = this.getDependencyGraph();
        LibraryDependencyGraph libraryDependencyGraph = new LibraryDependencyGraph();
        for (ICompilationUnit unit : swcUnits) {
            Set<DependencyGraph.Edge> dependencies = unitGraph.getOutgoingEdges(unit);
            if (dependencies.size() == 0) {
                libraryDependencyGraph.addLibrary(unit.getAbsoluteFilename());
            }
            for (DependencyGraph.Edge dependency : dependencies) {
                ICompilationUnit to;
                ICompilationUnit from = (ICompilationUnit)dependency.getFrom();
                if (!this.isInterSWCDependency(from, to = (ICompilationUnit)dependency.getTo()) || dependencySet != null && !dependency.typeInSet(dependencySet) && !dependencySet.isEmpty()) continue;
                libraryDependencyGraph.addLibrary(from.getAbsoluteFilename());
                libraryDependencyGraph.addLibrary(to.getAbsoluteFilename());
                libraryDependencyGraph.addDependency(from.getAbsoluteFilename(), to.getAbsoluteFilename(), dependency.getNamedDependencies());
            }
        }
        return libraryDependencyGraph;
    }

    private boolean isInterSWCDependency(ICompilationUnit from, ICompilationUnit to) {
        if (from.getAbsoluteFilename() != null && !from.getAbsoluteFilename().equals(to.getAbsoluteFilename())) {
            if (this.hasShadowedCompulationUnit(to, from.getAbsoluteFilename())) {
                return false;
            }
            return !this.hasShadowedCompulationUnit(from, to.getAbsoluteFilename());
        }
        return false;
    }

    private boolean hasShadowedCompulationUnit(ICompilationUnit unit, String swcPath) {
        List<IDefinition> definitionPromises = unit.getDefinitionPromises();
        if (definitionPromises == null || definitionPromises.size() == 0) {
            return false;
        }
        ASProjectScope scope = this.getScope();
        Set<IDefinition> toDefs = scope.getShadowedDefinitions(definitionPromises.get(0));
        if (toDefs != null) {
            for (IDefinition def : toDefs) {
                ICompilationUnit shadowedUnit = scope.getCompilationUnitForDefinition(def);
                if (!swcPath.equals(shadowedUnit.getAbsoluteFilename())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<File> populateIncludedSourceFiles(Collection<File> includedSources) {
        HashSet<File> includedSourceFiles = new HashSet<File>();
        for (File file : includedSources) {
            if (file.isFile()) {
                includedSourceFiles.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            for (File fileInFolder : FileUtils.listFiles((File)file, (String[])new String[]{"as", "mxml"}, (boolean)true)) {
                includedSourceFiles.add(fileInFolder);
            }
        }
        return includedSourceFiles;
    }

    @Override
    public List<String> getThemeNames() {
        return Lists.transform(this.getThemeFiles(), ThemeUtilities.THEME_FILE_TO_NAME);
    }

    @Override
    public void clean() {
        super.clean();
        this.manifestManager = null;
    }

    @Override
    public boolean isRoyale() {
        return this.isRoyale;
    }

    @Override
    public void setRoyale(boolean value) {
        this.isRoyale = value;
    }

    @Override
    public void setExcludeNativeJSLibraries(boolean value) {
    }

    @Override
    public String getActualPackageName(String packageName) {
        if (packageName.startsWith("window.")) {
            return packageName.substring(7);
        }
        if (packageName.equals("window")) {
            return "";
        }
        return packageName;
    }

    @Override
    public IDefinition doubleCheckAmbiguousDefinition(IASScope scope, String name, IDefinition def1, IDefinition def2) {
        IScopedDefinition scopeDef = ((ASScope)scope).getContainingDefinition();
        String thisPackage = null;
        if (scopeDef != null) {
            thisPackage = scopeDef.getPackageName();
        } else if (scope instanceof ASFileScope) {
            thisPackage = "";
        } else {
            while (!(scope instanceof PackageScope)) {
                scope = scope.getContainingScope();
            }
            if (!(scope instanceof PackageScope)) {
                return null;
            }
            thisPackage = ((PackageScope)scope).getDefinition().getBaseName();
        }
        String package1 = def1.getPackageName();
        String package2 = def2.getPackageName();
        if (package1.equals(thisPackage) && package2.length() == 0) {
            return def1;
        }
        if (package2.equals(thisPackage) && package1.length() == 0) {
            return def2;
        }
        if (package1.length() == 0 || package2.length() == 0) {
            ASScope pkgScope = (ASScope)scope;
            while (!(pkgScope instanceof PackageScope) && !(pkgScope instanceof ASFileScope)) {
                pkgScope = pkgScope.getContainingScope();
            }
            String[] imports = pkgScope.getImports();
            String windowName = "window." + name;
            boolean usingWindow = false;
            for (String imp : imports) {
                if (!imp.equals(windowName)) continue;
                usingWindow = true;
                break;
            }
            if (!usingWindow) {
                if (package1.length() == 0 && package2.length() == 0) {
                    IDefinitionSet defSet;
                    if (pkgScope instanceof PackageScope) {
                        pkgScope = pkgScope.getContainingScope();
                    }
                    if (pkgScope.getAllLocalNames().contains(name) && (defSet = pkgScope.getLocalDefinitionSetByName(name)).getSize() == 1) {
                        return defSet.getDefinition(0);
                    }
                }
                return package1.length() == 0 ? def2 : def1;
            }
        }
        return null;
    }

    public boolean useStrictXML() {
        return this.strictXML;
    }

    public boolean setStrictXML(boolean strictXML) {
        this.strictXML = strictXML;
        return this.strictXML;
    }

    public String getGeneratedIDBase(IMXMLClassDefinitionNode definitionNode) {
        IClassDefinition classDefinition = definitionNode.getDefinition();
        return "#_" + classDefinition.resolveAncestry(this).length + "_";
    }

    @Override
    public boolean isCompatibleOverrideReturnType(IFunctionDefinition func, ITypeDefinition overrideDefinition, ITypeDefinition baseDefinition) {
        if (baseDefinition == overrideDefinition) {
            return true;
        }
        if (this.targetSettings != null && this.targetSettings.getAllowSubclassOverrides() && overrideDefinition != null && baseDefinition != null) {
            IMetaTag[] metas;
            if (overrideDefinition.isInstanceOf(baseDefinition.getQualifiedName(), (ICompilerProject)this)) {
                return true;
            }
            FunctionDefinition f = (FunctionDefinition)func;
            for (IMetaTag meta : metas = f.getAllMetaTags()) {
                IMetaTagAttribute attr;
                if (!meta.getTagName().equals("SWFOverride") || (attr = meta.getAttribute("returns")) == null || !attr.getValue().equals(baseDefinition.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatibleOverrideParameterType(IFunctionDefinition func, ITypeDefinition overrideDefinition, ITypeDefinition baseDefinition, int i) {
        if (baseDefinition == overrideDefinition) {
            return true;
        }
        if (this.targetSettings != null && this.targetSettings.getAllowSubclassOverrides() && overrideDefinition != null && baseDefinition != null) {
            IMetaTag[] metas;
            if (overrideDefinition.isInstanceOf(baseDefinition.getQualifiedName(), (ICompilerProject)this)) {
                return true;
            }
            FunctionDefinition f = (FunctionDefinition)func;
            for (IMetaTag meta : metas = f.getAllMetaTags()) {
                String paramList;
                String[] parts;
                IMetaTagAttribute attr;
                if (!meta.getTagName().equals("SWFOverride") || (attr = meta.getAttribute("params")) == null || !(parts = (paramList = attr.getValue()).contains(",") ? paramList.split(",") : new String[]{paramList})[i].equals(baseDefinition.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValidTypeConversion(IASNode node, IDefinition actualDefinition, IDefinition expectedDefinition, IFunctionDefinition func) {
        IMetaTag[] metas;
        if (actualDefinition.getBaseName().equals("int") && expectedDefinition.getBaseName().equals("Function") && node.getParent().getNodeID() == ASTNodeID.ContainerID && node.getParent().getParent().getNodeID() == ASTNodeID.FunctionCallID && func.getParent().getQualifiedName().equals("Array") && func.getBaseName().equals("sort")) {
            return true;
        }
        if (func == null) {
            return false;
        }
        for (IMetaTag meta : metas = func.getAllMetaTags()) {
            IMetaTagAttribute altattr;
            if (!meta.getTagName().equals("SWFOverride") || (altattr = meta.getAttribute("altparams")) == null) continue;
            String altparamList = altattr.getValue();
            String[] altparamMap = altparamList.contains(",") ? altparamList.split(",") : new String[]{altparamList};
            IMetaTagAttribute attr = meta.getAttribute("params");
            if (attr == null) continue;
            String paramList = attr.getValue();
            String[] paramMap = paramList.contains(",") ? paramList.split(",") : new String[]{paramList};
            int n = paramMap.length;
            for (int i = 0; i < n; ++i) {
                String item = paramMap[i];
                if (!((ITypeDefinition)expectedDefinition).isInstanceOf(item, (ICompilerProject)this)) continue;
                String alts = altparamMap[i];
                String[] altList = alts.contains(":") ? alts.split(":") : new String[]{alts};
                for (String alt : altList) {
                    if (!((ITypeDefinition)actualDefinition).isInstanceOf(alt, (ICompilerProject)this)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<String> getCompilerExternalLibraryPath(Configuration config) {
        List<String> list = config.getCompilerSwfExternalLibraryPath();
        if (list != null && list.size() > 0) {
            return list;
        }
        return config.getCompilerExternalLibraryPath();
    }

    @Override
    public List<String> getCompilerLibraryPath(Configuration config) {
        List<String> list = config.getCompilerSwfLibraryPath();
        if (list != null && list.size() > 0) {
            return list;
        }
        return config.getCompilerLibraryPath();
    }

    @Override
    public List<MXMLNamespaceMapping> getCompilerNamespacesManifestMappings(Configuration config) {
        return config.getCompilerNamespacesManifestMappings();
    }

    @Override
    public Map<String, String> getCompilerDefine(Configuration config) {
        Map<String, String> list = config.getCompilerDefine();
        return list;
    }

    @Override
    public boolean getAllowPrivateNameConflicts() {
        return this.allowPrivateNameConflicts;
    }

    public void setAllowPrivateNameConflicts(boolean allow) {
        this.allowPrivateNameConflicts = allow;
    }

    @Override
    public boolean getAllowImportAliases() {
        return this.allowImportAliases;
    }

    public void setAllowImportAliases(boolean allow) {
        this.allowImportAliases = allow;
    }

    @Override
    public boolean getAllowAbstractClasses() {
        return this.allowAbstractClasses;
    }

    public void setAllowAbstractClasses(boolean allow) {
        this.allowAbstractClasses = allow;
    }

    @Override
    public boolean getAllowPrivateConstructors() {
        return this.allowPrivateConstructors;
    }

    public void setAllowPrivateConstructors(boolean allow) {
        this.allowPrivateConstructors = allow;
    }

    @Override
    public boolean getStrictIdentifierNames() {
        return this.strictIdentifierNames;
    }

    public void setStrictIdentifierNames(boolean enabled) {
        this.strictIdentifierNames = enabled;
    }

    @Override
    public boolean isPlatformRule(ICSSRule rule) {
        return true;
    }

    public void generateAPIReport() throws IOException {
        if (this.apiReportFile == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.apiMap.keySet();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(keys);
        Collections.sort(list);
        for (String key : list) {
            sb.append(key);
            sb.append(",");
            sb.append(this.apiMap.get(key).toString());
            sb.append("\n");
        }
        if (!this.apiReportFile.exists()) {
            this.apiReportFile.createNewFile();
        }
        FileWriter fw = new FileWriter(this.apiReportFile, false);
        fw.write(sb.toString());
        fw.close();
    }

    public void addToAPIReport(IClassDefinition c, IDefinition def) {
        String cqname = c.getQualifiedName();
        String qname = cqname + ":" + def.getQualifiedName();
        if (!this.apiMap.containsKey(qname)) {
            this.apiMap.put(qname, new Integer(1));
            return;
        }
        Integer counter = this.apiMap.get(qname);
        int newCounter = counter + 1;
        this.apiMap.put(qname, new Integer(newCounter));
    }

    public void addToAPIReport(IDefinition def) {
        IDefinition parentDef = def.getParent();
        if (parentDef instanceof IClassDefinition) {
            this.addToAPIReport((IClassDefinition)parentDef, def);
        } else if (!(parentDef instanceof IFunctionDefinition)) {
            String qname = def.getQualifiedName();
            if (!this.apiMap.containsKey(qname)) {
                this.apiMap.put(qname, new Integer(1));
                return;
            }
            Integer counter = this.apiMap.get(qname);
            int newCounter = counter + 1;
            this.apiMap.put(qname, new Integer(newCounter));
        }
    }

    @Override
    public boolean isParameterCountMismatchAllowed(IFunctionDefinition func, int formalCount, int actualCount) {
        if (!this.isTranspiling) {
            return false;
        }
        return func.getBaseName().equals("sort") && func.getParent().getQualifiedName().equals("Array") && formalCount == 1 && actualCount == 2;
    }

    @Override
    public File getLinkReport(Configuration config) {
        return config.getLinkReport();
    }

    public String getSwfDebugfileAlias() {
        return this.swfDebugfileAlias;
    }

    public void setSwfDebugfileAlias(String swfDebugfileAlias) {
        this.swfDebugfileAlias = swfDebugfileAlias;
    }

    @Override
    public boolean isStaticTypedTarget() {
        return true;
    }

    @Override
    public HashMap<IClassDefinition, BindingDatabase> getBindingMap() {
        return this.bindingMap;
    }
}

