/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl;

import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.exception.DLedgerException;
import io.openmessaging.storage.dledger.snapshot.SnapshotReader;
import io.openmessaging.storage.dledger.snapshot.SnapshotWriter;
import io.openmessaging.storage.dledger.statemachine.CommittedEntryIterator;
import io.openmessaging.storage.dledger.statemachine.StateMachine;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventSerializer;
import org.apache.rocketmq.controller.impl.manager.ReplicasInfoManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class DLedgerControllerStateMachine
implements StateMachine {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final ReplicasInfoManager replicasInfoManager;
    private final EventSerializer eventSerializer;
    private final String dLedgerId;

    public DLedgerControllerStateMachine(ReplicasInfoManager replicasInfoManager, EventSerializer eventSerializer, String dLedgerGroupId, String dLedgerSelfId) {
        this.replicasInfoManager = replicasInfoManager;
        this.eventSerializer = eventSerializer;
        this.dLedgerId = this.generateDLedgerId(dLedgerGroupId, dLedgerSelfId);
    }

    public String generateDLedgerId(String dLedgerGroupId, String dLedgerSelfId) {
        return new StringBuilder(20).append(dLedgerGroupId).append("#").append(dLedgerSelfId).toString();
    }

    public void onApply(CommittedEntryIterator iterator) {
        int applyingSize = 0;
        long firstApplyIndex = -1L;
        long lastApplyIndex = -1L;
        while (iterator.hasNext()) {
            DLedgerEntry entry = iterator.next();
            byte[] body = entry.getBody();
            if (body != null && body.length > 0) {
                EventMessage event = this.eventSerializer.deserialize(body);
                this.replicasInfoManager.applyEvent(event);
            }
            firstApplyIndex = firstApplyIndex == -1L ? entry.getIndex() : firstApplyIndex;
            lastApplyIndex = entry.getIndex();
            ++applyingSize;
        }
        log.info("Apply {} events index from {} to {} on controller {}", new Object[]{applyingSize, firstApplyIndex, lastApplyIndex, this.dLedgerId});
    }

    public boolean onSnapshotSave(SnapshotWriter writer) {
        return true;
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        return false;
    }

    public void onShutdown() {
        log.info("StateMachine {} onShutdown", (Object)this.dLedgerId);
    }

    public void onError(DLedgerException exception) {
        log.error("Encountered an error on StateMachine {}, dLedger may stop working since some error occurs, you should figure out the cause and repair or remove this node.", (Object)this.dLedgerId, (Object)exception);
    }

    public String getBindDLedgerId() {
        return this.dLedgerId;
    }
}

