/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.expositionformats;

import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.shaded.com_google_protobuf_4_28_3.MessageOrBuilder;
import io.prometheus.metrics.shaded.com_google_protobuf_4_28_3.TextFormat;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class TextFormatUtil {
    static void writeLong(OutputStreamWriter writer, long value) throws IOException {
        writer.append(Long.toString(value));
    }

    static void writeDouble(OutputStreamWriter writer, double d) throws IOException {
        if (d == Double.POSITIVE_INFINITY) {
            writer.write("+Inf");
        } else if (d == Double.NEGATIVE_INFINITY) {
            writer.write("-Inf");
        } else {
            writer.write(Double.toString(d));
        }
    }

    static void writeTimestamp(OutputStreamWriter writer, long timestampMs) throws IOException {
        writer.write(Long.toString(timestampMs / 1000L));
        writer.write(".");
        long ms = timestampMs % 1000L;
        if (ms < 100L) {
            writer.write("0");
        }
        if (ms < 10L) {
            writer.write("0");
        }
        writer.write(Long.toString(ms));
    }

    static void writeEscapedLabelValue(Writer writer, String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    writer.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block5;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    static void writeLabels(OutputStreamWriter writer, Labels labels, String additionalLabelName, double additionalLabelValue) throws IOException {
        writer.write(123);
        for (int i = 0; i < labels.size(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            writer.write(labels.getPrometheusName(i));
            writer.write("=\"");
            TextFormatUtil.writeEscapedLabelValue(writer, labels.getValue(i));
            writer.write("\"");
        }
        if (additionalLabelName != null) {
            if (!labels.isEmpty()) {
                writer.write(",");
            }
            writer.write(additionalLabelName);
            writer.write("=\"");
            TextFormatUtil.writeDouble(writer, additionalLabelValue);
            writer.write("\"");
        }
        writer.write(125);
    }

    public static String shortDebugString(MessageOrBuilder protobufData) {
        return TextFormat.printer().emittingSingleLine(true).printToString(protobufData);
    }
}

