/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private static Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static void string2File(String str, String fileName) throws IOException {
        String tmpFile = fileName + ".tmp";
        IOUtils.string2FileNotSafe(str, tmpFile);
        String bakFile = fileName + ".bak";
        String prevContent = IOUtils.file2String(fileName);
        if (prevContent != null) {
            IOUtils.string2FileNotSafe(prevContent, bakFile);
        }
        File file = new File(fileName);
        file.delete();
        file = new File(tmpFile);
        file.renameTo(new File(fileName));
    }

    public static void string2FileNotSafe(String str, String fileName) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null) {
            fileParent.mkdirs();
        }
        try (FileWriter fileWriter = null;){
            fileWriter = new FileWriter(file);
            fileWriter.write(str);
        }
    }

    public static String file2String(String fileName) throws IOException {
        File file = new File(fileName);
        return IOUtils.file2String(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(File file) throws IOException {
        if (file.exists()) {
            boolean result;
            byte[] data = new byte[(int)file.length()];
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(file);
                int len = inputStream.read(data);
                result = len == data.length;
            }
            if (result) {
                return new String(data);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(URL url) {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            int len = in.available();
            byte[] data = new byte[len];
            in.read(data, 0, len);
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String properties2String(Properties properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return sb.toString();
    }

    public static Properties string2Properties(String str) {
        Properties properties = new Properties();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(DEFAULT_CHARSET));
            properties.load(in);
        }
        catch (Exception e) {
            return null;
        }
        return properties;
    }

    public static Properties object2Properties(Object object) {
        Field[] fields;
        Properties properties = new Properties();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (value == null) continue;
            properties.setProperty(name, value.toString());
        }
        return properties;
    }

    public static void properties2Object(Properties p, Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            String mn = method.getName();
            if (!mn.startsWith("set")) continue;
            try {
                Class<?>[] pt;
                String tmp = mn.substring(4);
                String first = mn.substring(3, 4);
                String key = first.toLowerCase() + tmp;
                String property = p.getProperty(key);
                if (property == null || (pt = method.getParameterTypes()) == null || pt.length <= 0) continue;
                String cn = pt[0].getSimpleName();
                Object arg = null;
                if (cn.equals("int") || cn.equals("Integer")) {
                    arg = Integer.parseInt(property);
                } else if (cn.equals("long") || cn.equals("Long")) {
                    arg = Long.parseLong(property);
                } else if (cn.equals("double") || cn.equals("Double")) {
                    arg = Double.parseDouble(property);
                } else if (cn.equals("boolean") || cn.equals("Boolean")) {
                    arg = Boolean.parseBoolean(property);
                } else if (cn.equals("float") || cn.equals("Float")) {
                    arg = Float.valueOf(Float.parseFloat(property));
                } else {
                    if (!cn.equals("String")) continue;
                    arg = property;
                }
                method.invoke(object, arg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isPropertiesEqual(Properties p1, Properties p2) {
        return p1.equals(p2);
    }

    public static List<String> getLocalInetAddress() {
        ArrayList<String> inetAddressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    inetAddressList.add(addrs.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("get local inet address fail", e);
        }
        return inetAddressList;
    }

    private static String localhost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Throwable e) {
            try {
                String candidatesHost = IOUtils.getLocalhostByNetworkInterface();
                if (candidatesHost != null) {
                    return candidatesHost;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException", e);
        }
    }

    public static String getLocalhostByNetworkInterface() throws SocketException {
        ArrayList<String> candidatesHost = new ArrayList<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if ("docker0".equals(networkInterface.getName()) || !networkInterface.isUp()) continue;
            Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress address = addrs.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (address instanceof Inet6Address) {
                    candidatesHost.add(address.getHostAddress());
                    continue;
                }
                return address.getHostAddress();
            }
        }
        if (!candidatesHost.isEmpty()) {
            return (String)candidatesHost.get(0);
        }
        return null;
    }

    public static boolean compareAndIncreaseOnly(AtomicLong target, long value) {
        long prev = target.get();
        while (value > prev) {
            boolean updated = target.compareAndSet(prev, value);
            if (updated) {
                return true;
            }
            prev = target.get();
        }
        return false;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                IOUtils.deleteFile(file1);
            }
            file.delete();
        }
    }
}

