/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.elect.impl;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.rocketmq.controller.elect.ElectPolicy;
import org.apache.rocketmq.controller.helper.BrokerLiveInfoGetter;
import org.apache.rocketmq.controller.helper.BrokerValidPredicate;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;

public class DefaultElectPolicy
implements ElectPolicy {
    private BrokerValidPredicate validPredicate;
    private BrokerLiveInfoGetter brokerLiveInfoGetter;
    private final Comparator<BrokerLiveInfo> comparator = (o1, o2) -> {
        if (o1.getEpoch() == o2.getEpoch()) {
            return o1.getMaxOffset() == o2.getMaxOffset() ? o1.getElectionPriority() - o2.getElectionPriority() : (int)(o2.getMaxOffset() - o1.getMaxOffset());
        }
        return o2.getEpoch() - o1.getEpoch();
    };

    public DefaultElectPolicy(BrokerValidPredicate validPredicate, BrokerLiveInfoGetter brokerLiveInfoGetter) {
        this.validPredicate = validPredicate;
        this.brokerLiveInfoGetter = brokerLiveInfoGetter;
    }

    public DefaultElectPolicy() {
    }

    @Override
    public Long elect(String clusterName, String brokerName, Set<Long> syncStateBrokers, Set<Long> allReplicaBrokers, Long oldMaster, Long preferBrokerId) {
        Long newMaster = null;
        if (syncStateBrokers != null) {
            newMaster = this.tryElect(clusterName, brokerName, syncStateBrokers, oldMaster, preferBrokerId);
        }
        if (newMaster != null) {
            return newMaster;
        }
        if (allReplicaBrokers != null) {
            newMaster = this.tryElect(clusterName, brokerName, allReplicaBrokers, oldMaster, preferBrokerId);
        }
        return newMaster;
    }

    private Long tryElect(String clusterName, String brokerName, Set<Long> brokers, Long oldMaster, Long preferBrokerId) {
        if (this.validPredicate != null) {
            brokers = brokers.stream().filter(brokerAddr -> this.validPredicate.check(clusterName, brokerName, (Long)brokerAddr)).collect(Collectors.toSet());
        }
        if (!brokers.isEmpty()) {
            if (brokers.contains(oldMaster) && (preferBrokerId == null || preferBrokerId.equals(oldMaster))) {
                return oldMaster;
            }
            if (preferBrokerId != null) {
                return brokers.contains(preferBrokerId) ? preferBrokerId : null;
            }
            if (this.brokerLiveInfoGetter != null) {
                TreeSet<BrokerLiveInfo> brokerLiveInfos = new TreeSet<BrokerLiveInfo>(this.comparator);
                brokers.forEach(brokerAddr -> brokerLiveInfos.add(this.brokerLiveInfoGetter.get(clusterName, brokerName, (Long)brokerAddr)));
                if (brokerLiveInfos.size() >= 1) {
                    return brokerLiveInfos.first().getBrokerId();
                }
            }
            return brokers.iterator().next();
        }
        return null;
    }

    public void setBrokerLiveInfoGetter(BrokerLiveInfoGetter brokerLiveInfoGetter) {
        this.brokerLiveInfoGetter = brokerLiveInfoGetter;
    }

    public void setValidPredicate(BrokerValidPredicate validPredicate) {
        this.validPredicate = validPredicate;
    }

    public BrokerLiveInfoGetter getBrokerLiveInfoGetter() {
        return this.brokerLiveInfoGetter;
    }
}

