/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.ranger.audit.utils.AbstractKerberosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosJAASConfigUser
extends AbstractKerberosUser {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosJAASConfigUser.class);
    private final String configName;
    private final Configuration config;

    public KerberosJAASConfigUser(String configName, Configuration config) {
        this.configName = configName;
        this.config = config;
    }

    @Override
    public String getPrincipal() {
        String ret = null;
        AppConfigurationEntry[] entries = this.config.getAppConfigurationEntry(this.configName);
        if (entries != null) {
            for (AppConfigurationEntry entry : entries) {
                if (!entry.getOptions().containsKey("principal")) continue;
                ret = (String)entry.getOptions().get("principal");
                break;
            }
        }
        return ret;
    }

    @Override
    protected LoginContext createLoginContext(Subject subject) throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> KerberosJAASConfigUser.createLoginContext()");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== KerberosJAASConfigUser.createLoginContext(), Subject: " + subject);
        }
        return new LoginContext(this.configName, subject, null, this.config);
    }
}

