/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.util.Collection;
import java.util.Properties;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JAuditDestination
extends AuditDestination {
    private static final Logger logger = LoggerFactory.getLogger(Log4JAuditDestination.class);
    private static Logger auditLogger = null;
    public static final String PROP_LOG4J_LOGGER = "logger";
    public static final String DEFAULT_LOGGER_PREFIX = "ranger.audit";
    private String loggerName = null;

    public Log4JAuditDestination() {
        logger.info("Log4JAuditDestination() called.");
    }

    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        this.loggerName = MiscUtil.getStringProperty((Properties)this.props, (String)(propPrefix + "." + PROP_LOG4J_LOGGER));
        if (this.loggerName == null || this.loggerName.isEmpty()) {
            this.loggerName = "ranger.audit." + this.getName();
            logger.info("Logger property " + propPrefix + "." + PROP_LOG4J_LOGGER + " was not set. Constructing default=" + this.loggerName);
        }
        logger.info("Logger name for " + this.getName() + " is " + this.loggerName);
        auditLogger = LoggerFactory.getLogger((String)this.loggerName);
        logger.info("Done initializing logger for audit. name=" + this.getName() + ", loggerName=" + this.loggerName);
    }

    public void stop() {
        super.stop();
        this.logStatus();
    }

    public boolean log(AuditEventBase event) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(1);
            return true;
        }
        if (event != null) {
            String eventStr = MiscUtil.stringify((Object)event);
            this.logJSON(eventStr);
        }
        return true;
    }

    public boolean log(Collection<AuditEventBase> events) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            return true;
        }
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }

    public boolean logJSON(String event) {
        this.logStatusIfRequired();
        this.addTotalCount(1);
        if (!auditLogger.isInfoEnabled()) {
            return true;
        }
        if (event != null) {
            auditLogger.info(event);
            this.addSuccessCount(1);
        }
        return true;
    }

    public boolean logJSON(Collection<String> events) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            return true;
        }
        for (String event : events) {
            this.logJSON(event);
        }
        return false;
    }
}

