/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.hbase.client.HBaseResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceHBase
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceHBase.class);
    public static final String ACCESS_TYPE_READ = "read";
    public static final String ACCESS_TYPE_CREATE = "create";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHbase.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_CREATE));
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHbase.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHBase.validateConfig() Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = HBaseResourceMgr.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException e) {
                LOG.error("<== RangerServiceHBase.validateConfig() Error:" + (Object)((Object)e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHBase.validateConfig() Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHBase.lookupResource() Service : " + serviceName + " Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = HBaseResourceMgr.getHBaseResource(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceHBase.lookupResource() Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHBase.lookupResource() Response: (" + ret + ")");
        }
        return ret;
    }
}

