/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.trino;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.trino.client.TrinoResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceTrino
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceTrino.class);
    public static final String ACCESS_TYPE_SELECT = "select";

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTrino.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_SELECT));
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            ArrayList<RangerPolicy.RangerPolicyItem> policyItems = defaultPolicy.getPolicyItems();
            if (policyItems == null || policyItems.isEmpty()) {
                policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
            }
            policyItems.add(policyItemForLookupUser);
            defaultPolicy.setPolicyItems(policyItems);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTrino.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceTrino.validateConfig(): Service: " + serviceName);
        }
        if (this.configs != null) {
            try {
                if (!this.configs.containsKey("password")) {
                    this.configs.put("password", null);
                }
                ret = TrinoResourceManager.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException he) {
                LOG.error("<== RangerServiceTrino.validateConfig() Error:" + (Object)((Object)he));
                throw he;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceTrino.validateConfig(): Response: " + ret);
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTrino.lookupResource() Context: (" + context + ")");
        }
        if (context != null) {
            try {
                if (!configs.containsKey("password")) {
                    configs.put("password", null);
                }
                ret = TrinoResourceManager.getTrinoResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceTrino.lookupResource() Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTrino.lookupResource() Response: (" + ret + ")");
        }
        return ret;
    }
}

