/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import lombok.Generated;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.jspecify.annotations.Nullable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface ManagedCursorContainer
extends Iterable<ManagedCursor> {
    public void add(ManagedCursor var1, Position var2);

    public @Nullable ManagedCursor get(String var1);

    public boolean removeCursor(String var1);

    public Pair<Position, Position> cursorUpdated(ManagedCursor var1, Position var2);

    public @Nullable Position getSlowestCursorPosition();

    public @Nullable ManagedCursor getSlowestCursor();

    public @Nullable CursorInfo getCursorWithOldestPosition();

    public boolean isEmpty();

    public int size();

    public boolean hasDurableCursors();

    public static final class DataVersion {
        public static int compareVersions(long v1, long v2) {
            if (v1 == v2) {
                return 0;
            }
            if (v2 > v1) {
                long distance = v2 - v1;
                long wrapAroundDistance = Long.MAX_VALUE - v2 + v1;
                if (distance < wrapAroundDistance) {
                    return -1;
                }
                return 1;
            }
            long distance = v1 - v2;
            long wrapAroundDistance = Long.MAX_VALUE - v1 + v2;
            if (distance < wrapAroundDistance) {
                return 1;
            }
            return -1;
        }

        public static long getNextVersion(long existingVersion) {
            if (existingVersion == Long.MAX_VALUE) {
                return 0L;
            }
            return existingVersion + 1L;
        }

        @Generated
        private DataVersion() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class CursorInfo {
        private final ManagedCursor cursor;
        private final Position position;
        private final long version;

        @Generated
        public CursorInfo(ManagedCursor cursor, Position position, long version) {
            this.cursor = cursor;
            this.position = position;
            this.version = version;
        }

        @Generated
        public ManagedCursor getCursor() {
            return this.cursor;
        }

        @Generated
        public Position getPosition() {
            return this.position;
        }

        @Generated
        public long getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CursorInfo)) {
                return false;
            }
            CursorInfo other = (CursorInfo)o;
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            ManagedCursor this$cursor = this.getCursor();
            ManagedCursor other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            Position this$position = this.getPosition();
            Position other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            ManagedCursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            Position $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ManagedCursorContainer.CursorInfo(cursor=" + String.valueOf(this.getCursor()) + ", position=" + String.valueOf(this.getPosition()) + ", version=" + this.getVersion() + ")";
        }
    }
}

