/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.AutoValue_Endpoints_DropOverload;
import io.grpc.xds.AutoValue_Endpoints_LbEndpoint;
import io.grpc.xds.AutoValue_Endpoints_LocalityLbEndpoints;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

final class Endpoints {
    private Endpoints() {
    }

    @AutoValue
    static abstract class DropOverload {
        DropOverload() {
        }

        abstract String category();

        abstract int dropsPerMillion();

        static DropOverload create(String category, int dropsPerMillion) {
            return new AutoValue_Endpoints_DropOverload(category, dropsPerMillion);
        }
    }

    @AutoValue
    static abstract class LbEndpoint {
        LbEndpoint() {
        }

        abstract EquivalentAddressGroup eag();

        abstract int loadBalancingWeight();

        abstract boolean isHealthy();

        abstract String hostname();

        abstract ImmutableMap<String, Object> endpointMetadata();

        static LbEndpoint create(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy, String hostname, ImmutableMap<String, Object> endpointMetadata) {
            return new AutoValue_Endpoints_LbEndpoint(eag, loadBalancingWeight, isHealthy, hostname, endpointMetadata);
        }

        @VisibleForTesting
        static LbEndpoint create(String address, int port, int loadBalancingWeight, boolean isHealthy, String hostname, ImmutableMap<String, Object> endpointMetadata) {
            return LbEndpoint.create(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port)), loadBalancingWeight, isHealthy, hostname, endpointMetadata);
        }
    }

    @AutoValue
    static abstract class LocalityLbEndpoints {
        LocalityLbEndpoints() {
        }

        abstract ImmutableList<LbEndpoint> endpoints();

        abstract int localityWeight();

        abstract int priority();

        abstract ImmutableMap<String, Object> localityMetadata();

        static LocalityLbEndpoints create(List<LbEndpoint> endpoints, int localityWeight, int priority, ImmutableMap<String, Object> localityMetadata) {
            Preconditions.checkArgument((localityWeight > 0 ? 1 : 0) != 0, (Object)"localityWeight must be greater than 0");
            return new AutoValue_Endpoints_LocalityLbEndpoints((ImmutableList<LbEndpoint>)ImmutableList.copyOf(endpoints), localityWeight, priority, localityMetadata);
        }
    }
}

