/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public abstract class RangeIterator
implements GroundedIterator {
    @Override
    public abstract GroundedValue getResidue();

    public abstract IntegerValue getFirst();

    public abstract IntegerValue getLast();

    public abstract IntegerValue getMin();

    public abstract IntegerValue getMax();

    public abstract IntegerValue getStep();

    public boolean containsEq(NumericValue val) {
        IntegerValue intVal;
        if (val instanceof IntegerValue) {
            intVal = (IntegerValue)val;
        } else {
            if (!val.isWholeNumber()) {
                return false;
            }
            try {
                intVal = (IntegerValue)Converter.NumericToInteger.INSTANCE.convert(val).asAtomic();
            }
            catch (ValidationException e) {
                return false;
            }
        }
        try {
            return intVal.compareTo(this.getMin()) >= 0 && intVal.compareTo(this.getMax()) <= 0 && intVal.minus(this.getFirst()).mod(this.getStep()).equals(Int64Value.ZERO);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }
}

