/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOUnion
extends LogicalRelationalOperator {
    private boolean onSchema;
    private static String UID_SEPARATOR = "_";
    private List<Pair<Long, String>> uidMapping = new ArrayList<Pair<Long, String>>();

    public LOUnion(OperatorPlan plan) {
        super("LOUnion", plan);
    }

    public LOUnion(OperatorPlan plan, boolean onSchema) {
        this(plan);
        this.onSchema = onSchema;
    }

    public boolean isOnSchema() {
        return this.onSchema;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        List<Operator> inputs = this.plan.getPredecessors(this);
        for (Operator input : inputs) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)input;
            if (op.getSchema() != null) continue;
            if (this.isOnSchema()) {
                String msg = "Schema of relation " + op.getAlias() + " is null. UNION ONSCHEMA cannot be used with relations that have null schema.";
                throw new FrontendException((Operator)this, msg, 1116, 2);
            }
            return null;
        }
        LogicalSchema mergedSchema = null;
        if (inputs.size() == 1) {
            this.schema = ((LogicalRelationalOperator)inputs.get(0)).getSchema();
            return this.schema;
        }
        ArrayList<String> inputAliases = new ArrayList<String>(inputs.size());
        ArrayList<LogicalSchema> inputSchemas = new ArrayList<LogicalSchema>(inputs.size());
        for (Operator input : inputs) {
            LogicalRelationalOperator lop = (LogicalRelationalOperator)input;
            inputAliases.add(lop.getAlias());
            inputSchemas.add(lop.getSchema());
        }
        if (this.isOnSchema()) {
            mergedSchema = this.createMergedSchemaOnAlias(inputSchemas, inputAliases);
        } else {
            LogicalSchema s1;
            LogicalSchema s0 = (LogicalSchema)inputSchemas.get(0);
            mergedSchema = LogicalSchema.merge(s0, s1 = (LogicalSchema)inputSchemas.get(1), LogicalSchema.MergeMode.Union);
            if (mergedSchema == null) {
                return null;
            }
            for (int i = 2; i < inputSchemas.size(); ++i) {
                LogicalSchema otherSchema = (LogicalSchema)inputSchemas.get(i);
                if (mergedSchema == null || otherSchema == null) {
                    return null;
                }
                if ((mergedSchema = LogicalSchema.merge(mergedSchema, otherSchema, LogicalSchema.MergeMode.Union)) != null) continue;
                return null;
            }
        }
        this.setMergedSchemaUids(mergedSchema, inputSchemas, "");
        this.schema = mergedSchema;
        return this.schema;
    }

    private LogicalSchema createMergedSchemaOnAlias(List<LogicalSchema> inputSchemas, List<String> inputAliases) throws FrontendException {
        ArrayList<LogicalSchema> schemas = new ArrayList<LogicalSchema>();
        for (int i = 0; i < inputSchemas.size(); ++i) {
            LogicalSchema sch = inputSchemas.get(i);
            for (LogicalSchema.LogicalFieldSchema fs : sch.getFields()) {
                if (fs.alias != null) continue;
                String msg = "Schema of relation " + inputAliases.get(i) + " has a null fieldschema for column(s). Schema :" + sch.toString(false);
                throw new FrontendException((Operator)this, msg, 1116, 2);
            }
            schemas.add(sch);
        }
        LogicalSchema mergedSchema = null;
        try {
            mergedSchema = LogicalSchema.mergeSchemasByAlias(schemas);
        }
        catch (FrontendException e) {
            String msg = "Error merging schemas for union operator : " + e.getMessage();
            throw new FrontendException(this, msg, 1116, 2, e);
        }
        return mergedSchema;
    }

    private void setMergedSchemaUids(LogicalSchema mergedSchema, List<LogicalSchema> inputSchemas, String nested_uids) throws FrontendException {
        for (int i = 0; i < mergedSchema.size(); ++i) {
            LogicalSchema.LogicalFieldSchema outputFieldSchema = mergedSchema.getField(i);
            long uid = -1L;
            ArrayList<LogicalSchema> fieldInputSchemas = new ArrayList<LogicalSchema>(inputSchemas.size());
            for (LogicalSchema inputSchema : inputSchemas) {
                LogicalSchema.LogicalFieldSchema inputFieldSchema = this.onSchema ? inputSchema.getFieldSubNameMatch(outputFieldSchema.alias) : inputSchema.getField(i);
                if (inputFieldSchema == null) continue;
                if (inputFieldSchema.schema != null) {
                    fieldInputSchemas.add(inputFieldSchema.schema);
                }
                if (uid >= 0L || (uid = this.getCachedOuputUid(this.createNestedUids(nested_uids, inputFieldSchema.uid))) < 0L || outputFieldSchema.schema != null) continue;
                break;
            }
            if (uid == -1L) {
                uid = LogicalExpression.getNextUid();
                for (LogicalSchema inputSchema : inputSchemas) {
                    LogicalSchema.LogicalFieldSchema matchedInputFieldSchema;
                    if (this.onSchema) {
                        matchedInputFieldSchema = inputSchema.getFieldSubNameMatch(mergedSchema.getField((int)i).alias);
                        if (matchedInputFieldSchema == null) continue;
                        long inputUid = matchedInputFieldSchema.uid;
                        this.uidMapping.add(new Pair<Long, String>(uid, this.createNestedUids(nested_uids, inputUid)));
                        continue;
                    }
                    matchedInputFieldSchema = mergedSchema.getField(i);
                    long inputUid = inputSchema.getField((int)i).uid;
                    this.uidMapping.add(new Pair<Long, String>(uid, this.createNestedUids(nested_uids, inputUid)));
                }
            }
            outputFieldSchema.uid = uid;
            if (outputFieldSchema.schema == null) continue;
            this.setMergedSchemaUids(outputFieldSchema.schema, fieldInputSchemas, this.createNestedUids(nested_uids, outputFieldSchema.uid));
        }
    }

    private String createNestedUids(String nested_uids, long new_uid) {
        StringBuilder sb = new StringBuilder(nested_uids);
        sb.append(UID_SEPARATOR);
        sb.append(new_uid);
        return sb.toString();
    }

    private long getLeafUid(String nested_uids) {
        String[] uid_root_to_leaf = nested_uids.split(UID_SEPARATOR);
        return Long.valueOf(uid_root_to_leaf[uid_root_to_leaf.length - 1]);
    }

    private long getCachedOuputUid(String nested_input_uids) {
        long uid = -1L;
        for (Pair<Long, String> pair : this.uidMapping) {
            if (!((String)pair.second).equals(nested_input_uids)) continue;
            uid = (Long)pair.first;
            break;
        }
        return uid;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOUnion) {
            return this.checkEquality((LOUnion)other);
        }
        return false;
    }

    public Set<Long> getInputUids(long outputuid) {
        HashSet<Long> result = new HashSet<Long>();
        for (Pair<Long, String> pair : this.uidMapping) {
            if ((Long)pair.first != outputuid) continue;
            result.add(this.getLeafUid((String)pair.second));
        }
        return result;
    }

    @Override
    public void resetUid() {
        this.uidMapping = new ArrayList<Pair<Long, String>>();
    }

    public List<Operator> getInputs() {
        return this.plan.getPredecessors(this);
    }

    public List<Operator> getInputs(LogicalPlan plan) {
        return plan.getPredecessors(this);
    }

    public void setUnionOnSchema(boolean flag) {
        this.onSchema = flag;
    }
}

