/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.server.master.state.TableCounts;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.hadoop.io.Text;

public class TableStats {
    private Map<Text, TableCounts> last = new HashMap<Text, TableCounts>();
    private Map<Text, TableCounts> next;
    private long startScan = 0L;
    private long endScan = 0L;

    public synchronized void begin() {
        this.next = new HashMap<Text, TableCounts>();
        this.startScan = System.currentTimeMillis();
    }

    public synchronized void update(Text tableId, TabletState state) {
        TableCounts counts = this.next.get(tableId);
        if (counts == null) {
            counts = new TableCounts();
            this.next.put(tableId, counts);
        }
        int n = state.ordinal();
        counts.counts[n] = counts.counts[n] + 1;
    }

    public synchronized void end() {
        this.last = this.next;
        this.next = null;
        this.endScan = System.currentTimeMillis();
    }

    public synchronized Map<Text, TableCounts> getLast() {
        return this.last;
    }

    public synchronized TableCounts getLast(Text tableId) {
        TableCounts result = this.last.get(tableId);
        if (result == null) {
            return new TableCounts();
        }
        return result;
    }

    public synchronized long getScanTime() {
        if (this.endScan <= this.startScan) {
            return System.currentTimeMillis() - this.startScan;
        }
        return this.endScan - this.startScan;
    }

    public synchronized long lastScanFinished() {
        return this.endScan;
    }
}

