/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.CellCounter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCellCounter {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static Path FQ_OUTPUT_DIR;
    private static final String OUTPUT_DIR;
    private static long now;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.setJobWithoutMRCluster();
        UTIL.startMiniCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified((FileSystem)new LocalFileSystem());
        FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounter() throws Exception {
        String sourceTable = "sourceTable";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, FQ_OUTPUT_DIR.toString(), ";", "^row1"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            t.close();
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounterStartTimeRange() throws Exception {
        String sourceTable = "testCellCounterStartTimeRange";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, FQ_OUTPUT_DIR.toString(), ";", "^row1", "--starttime=" + now, "--endtime=" + now + 2};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            t.close();
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounteEndTimeRange() throws Exception {
        String sourceTable = "testCellCounterEndTimeRange";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, FQ_OUTPUT_DIR.toString(), ";", "^row1", "--endtime=" + now + 1};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            t.close();
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounteOutOfTimeRange() throws Exception {
        String sourceTable = "testCellCounterOutTimeRange";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, FQ_OUTPUT_DIR.toString(), ";", "--starttime=" + now + 1, "--endtime=" + now + 2};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.isEmpty());
        }
        finally {
            t.close();
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    private boolean runCount(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration configuration = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = CellCounter.createSubmittableJob((Configuration)configuration, (String[])args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounterMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                CellCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage:"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounterForCompleteTable() throws Exception {
        String sourceTable = "testCellCounterForCompleteTable";
        String outputPath = OUTPUT_DIR + sourceTable;
        LocalFileSystem localFileSystem = new LocalFileSystem();
        Path outputDir = new Path(outputPath).makeQualified(localFileSystem.getUri(), localFileSystem.getWorkingDirectory());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, outputDir.toString(), ";"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(outputPath + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t4"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t2"));
            Assert.assertTrue((boolean)data.contains("b;q\t2"));
            Assert.assertTrue((boolean)data.contains("a;q\t2"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row2;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row2;b;q_Versions\t1"));
        }
        finally {
            t.close();
            FileUtil.fullyDelete((File)new File(outputPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void TestCellCounterWithoutOutputDir() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{"tableName"};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                CellCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage:"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    static {
        OUTPUT_DIR = "target" + File.separator + "test-data" + File.separator + "output";
        now = System.currentTimeMillis();
    }
}

