/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.util.StringUtil;
import junit.util.Version;

public class TestRunner
implements TestListener {
    PrintStream fWriter;

    public TestRunner() {
    }

    public TestRunner(PrintStream printStream) {
        this();
        this.fWriter = printStream;
    }

    public synchronized void addError(Test test, Throwable throwable) {
        this.writer().print("E");
    }

    public synchronized void addFailure(Test test, Throwable throwable) {
        this.writer().print("F");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void doRun(Test test, boolean bl) {
        TestResult testResult = this.createTestResult();
        testResult.addListener(this);
        long l = System.currentTimeMillis();
        test.run(testResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.writer().println();
        this.writer().println("Time: " + StringUtil.elapsedTimeAsString(l3));
        this.print(testResult);
        this.writer().println();
        if (bl) {
            this.writer().println("<RETURN> to continue");
            try {
                System.in.read();
            }
            catch (Exception exception) {}
        }
        if (!testResult.wasSuccessful()) {
            System.exit(-1);
        }
        System.exit(0);
    }

    public void endTest(Test test) {
    }

    private String extractClassName(String string) {
        if (string.startsWith("Default package for")) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        TestRunner testRunner = new TestRunner();
        testRunner.start(stringArray);
    }

    public synchronized void print(TestResult testResult) {
        this.printHeader(testResult);
        this.printErrors(testResult);
        this.printFailures(testResult);
    }

    public void printErrors(TestResult testResult) {
        if (testResult.errorCount() != 0) {
            if (testResult.errorCount() == 1) {
                this.writer().println("There was " + testResult.errorCount() + " error:");
            } else {
                this.writer().println("There were " + testResult.errorCount() + " errors:");
            }
            int n = 1;
            Enumeration enumeration = testResult.errors();
            while (enumeration.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)enumeration.nextElement();
                this.writer().println(String.valueOf(n) + ") " + testFailure.failedTest());
                testFailure.thrownException().printStackTrace();
                ++n;
            }
        }
    }

    public void printFailures(TestResult testResult) {
        if (testResult.failureCount() != 0) {
            if (testResult.failureCount() == 1) {
                this.writer().println("There was " + testResult.failureCount() + " failure:");
            } else {
                this.writer().println("There were " + testResult.failureCount() + " failures:");
            }
            int n = 1;
            Enumeration enumeration = testResult.failures();
            while (enumeration.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)enumeration.nextElement();
                this.writer().print(String.valueOf(n) + ") " + testFailure.failedTest());
                Throwable throwable = testFailure.thrownException();
                if (throwable.getMessage() != null) {
                    this.writer().println(" \"" + StringUtil.truncate(throwable.getMessage(), 80) + "\"");
                } else {
                    this.writer().println();
                    testFailure.thrownException().printStackTrace();
                }
                ++n;
            }
        }
    }

    public void printHeader(TestResult testResult) {
        if (testResult.wasSuccessful()) {
            this.writer().println();
            this.writer().print("OK");
            this.writer().println(" (" + testResult.runCount() + " tests)");
        } else {
            this.writer().println();
            this.writer().println("FAILURES!!!");
            this.writer().println("Test Results:");
            this.writer().println("Run: " + testResult.runCount() + " Failures: " + testResult.failureCount() + " Errors: " + testResult.errorCount());
        }
    }

    public static void run(Class clazz) {
        TestRunner.run(new TestSuite(clazz));
    }

    public static void run(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test, false);
    }

    public static void runAndWait(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test, true);
    }

    protected void start(String[] stringArray) {
        String string = "";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-wait")) {
                bl = true;
            } else if (stringArray[n].equals("-c")) {
                string = StringUtil.extractClassName(stringArray[++n]);
            } else if (stringArray[n].equals("-v")) {
                System.out.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        if (string.equals("")) {
            System.out.println("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
            System.exit(-1);
        }
        try {
            Class<?> clazz = null;
            Method method = null;
            Test test = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                System.out.println("Suite class \"" + string + "\" not found");
                System.exit(-1);
            }
            try {
                method = clazz.getMethod("suite", new Class[0]);
            }
            catch (Exception exception) {
                test = new TestSuite(clazz);
            }
            if (test == null) {
                try {
                    test = (Test)method.invoke(null, (Object[])new Class[0]);
                }
                catch (Exception exception) {
                    System.out.println("Could not invoke the suite() method");
                    System.exit(-1);
                }
            }
            this.doRun(test, bl);
        }
        catch (Exception exception) {
            System.out.println("Could not create and run test suite");
            System.exit(-1);
        }
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    private PrintStream writer() {
        if (this.fWriter == null) {
            return System.out;
        }
        return this.fWriter;
    }
}

