/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iterators.conf.ColumnSet;
import org.apache.accumulo.core.iterators.conf.ColumnUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.hadoop.io.Text;

public class ColumnToClassMapping<K> {
    private HashMap<ColumnUtil.ColFamHashKey, K> objectsCF;
    private HashMap<ColumnUtil.ColHashKey, K> objectsCol;
    private ColumnUtil.ColHashKey lookupCol = new ColumnUtil.ColHashKey();
    private ColumnUtil.ColFamHashKey lookupCF = new ColumnUtil.ColFamHashKey();

    public ColumnToClassMapping() {
        this.objectsCF = new HashMap();
        this.objectsCol = new HashMap();
    }

    public ColumnToClassMapping(Map<String, String> objectStrings, Class<? extends K> c) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this();
        for (Map.Entry<String, String> entry : objectStrings.entrySet()) {
            String column = entry.getKey();
            String className = entry.getValue();
            Pair<Text, Text> pcic = ColumnSet.decodeColumns(column);
            Class clazz = AccumuloVFSClassLoader.loadClass((String)className, c);
            if (pcic.getSecond() == null) {
                this.addObject(pcic.getFirst(), clazz.newInstance());
                continue;
            }
            this.addObject(pcic.getFirst(), pcic.getSecond(), clazz.newInstance());
        }
    }

    protected void addObject(Text colf, K obj) {
        this.objectsCF.put(new ColumnUtil.ColFamHashKey(new Text(colf)), (ColumnUtil.ColFamHashKey)obj);
    }

    protected void addObject(Text colf, Text colq, K obj) {
        this.objectsCol.put(new ColumnUtil.ColHashKey(colf, colq), (ColumnUtil.ColHashKey)obj);
    }

    public K getObject(Key key) {
        K obj = null;
        if (this.objectsCol.size() > 0) {
            this.lookupCol.set(key);
            obj = this.objectsCol.get(this.lookupCol);
            if (obj != null) {
                return obj;
            }
        }
        if (this.objectsCF.size() > 0) {
            this.lookupCF.set(key);
            obj = this.objectsCF.get(this.lookupCF);
        }
        return obj;
    }

    public boolean isEmpty() {
        return this.objectsCol.size() == 0 && this.objectsCF.size() == 0;
    }
}

