/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Scanner;
import jline.ConsoleReader;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;

public class MockShell
extends Shell {
    private static final String NEWLINE = "\n";
    protected InputStream in;
    protected Writer writer;

    public MockShell(InputStream in, Writer writer) throws IOException {
        this.in = in;
        this.writer = writer;
    }

    @Override
    public boolean config(String ... args) {
        this.configError = super.config(args);
        try {
            this.reader = new ConsoleReader(this.in, this.writer);
        }
        catch (Exception e) {
            this.printException(e);
            this.configError = true;
        }
        this.reader.setUseHistory(false);
        this.reader.setUsePagination(false);
        this.verbose = false;
        return this.configError;
    }

    @Override
    protected void setInstance(CommandLine cl) {
        this.instance = new MockInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start() throws IOException {
        if (this.configError) {
            return 1;
        }
        if (this.isVerbose()) {
            this.printInfo();
        }
        if (this.execFile != null) {
            Scanner scanner = new Scanner(new File(this.execFile));
            try {
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
            finally {
                scanner.close();
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split(NEWLINE)) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (!this.hasExited()) {
            this.reader.setDefaultPrompt(this.getDefaultPrompt());
            String input = this.reader.readLine();
            if (input == null) {
                this.reader.printNewline();
                return this.exitCode;
            }
            this.execCommand(input, false, false);
        }
        return this.exitCode;
    }

    public void setConsoleInputStream(InputStream in) {
        this.in = in;
    }

    public void setConsoleWriter(Writer writer) {
        this.writer = writer;
    }

    public static ByteArrayInputStream makeCommands(String ... commands) {
        StringBuilder sb = new StringBuilder(commands.length * 8);
        for (String command : commands) {
            sb.append(command).append(NEWLINE);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

