/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.mock.MockBatchScanner;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.client.mock.MockUser;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class MockAccumulo {
    final Map<String, MockTable> tables = new HashMap<String, MockTable>();
    final Map<String, String> systemProperties = new HashMap<String, String>();
    Map<String, MockUser> users = new HashMap<String, MockUser>();
    final FileSystem fs;

    MockAccumulo(FileSystem fs) {
        MockUser root = new MockUser("root", new PasswordToken(new byte[0]), Constants.NO_AUTHS);
        root.permissions.add(SystemPermission.SYSTEM);
        this.users.put(root.name, root);
        this.createTable("root", "!METADATA", true, TimeType.LOGICAL);
        this.fs = fs;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    void setProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    String removeProperty(String key) {
        return this.systemProperties.remove(key);
    }

    void createTable(String user, String table) {
        this.createTable(user, table, true, TimeType.MILLIS);
    }

    public void addMutation(String table, Mutation m) {
        MockTable t = this.tables.get(table);
        t.addMutation(m);
    }

    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations) {
        return new MockBatchScanner(this.tables.get(tableName), authorizations);
    }

    public void createTable(String username, String tableName, boolean useVersions, TimeType timeType) {
        MockTable t = new MockTable(useVersions, timeType);
        t.userPermissions.put(username, EnumSet.allOf(TablePermission.class));
        this.tables.put(tableName, t);
    }

    public void addSplits(String tableName, SortedSet<Text> partitionKeys) {
        this.tables.get(tableName).addSplits(partitionKeys);
    }

    public Collection<Text> getSplits(String tableName) {
        return this.tables.get(tableName).getSplits();
    }

    public void merge(String tableName, Text start, Text end) {
        this.tables.get(tableName).merge(start, end);
    }
}

